/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.provider;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RosterPacketProvider
extends IQProvider<RosterPacket> {
    public static final RosterPacketProvider INSTANCE = new RosterPacketProvider();

    /*
     * Enabled aggressive block sorting
     */
    public RosterPacket parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        RosterPacket roster = new RosterPacket();
        RosterPacket.Item item = null;
        String version = parser.getAttributeValue("", "ver");
        roster.setVersion(version);
        while (true) {
            int eventType = parser.next();
            block0 : switch (eventType) {
                case 2: {
                    String startTag;
                    switch (startTag = parser.getName()) {
                        case "item": {
                            String jid = parser.getAttributeValue("", "jid");
                            String name = parser.getAttributeValue("", "name");
                            item = new RosterPacket.Item(jid, name);
                            String ask = parser.getAttributeValue("", "ask");
                            RosterPacket.ItemStatus status = RosterPacket.ItemStatus.fromString(ask);
                            item.setItemStatus(status);
                            String subscription = parser.getAttributeValue("", "subscription");
                            RosterPacket.ItemType type = RosterPacket.ItemType.valueOf(subscription != null ? subscription : "none");
                            item.setItemType(type);
                            break;
                        }
                        case "group": {
                            String groupName = parser.nextText();
                            if (groupName != null && groupName.trim().length() > 0) {
                                item.addGroupName(groupName);
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    String endTag;
                    switch (endTag = parser.getName()) {
                        case "item": {
                            roster.addRosterItem(item);
                            break block0;
                        }
                        case "query": {
                            return roster;
                        }
                    }
                }
            }
        }
    }
}

