/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentEvent;
import org.imixs.workflow.engine.EventLogService;
import org.imixs.workflow.engine.UserGroupEvent;
import org.imixs.workflow.engine.index.DefaultOperator;
import org.imixs.workflow.engine.index.SearchService;
import org.imixs.workflow.engine.index.SortOrder;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.engine.jpa.Document;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.exceptions.QueryException;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class DocumentService {
    public static final String ACCESSLEVEL_NOACCESS = "org.imixs.ACCESSLEVEL.NOACCESS";
    public static final String ACCESSLEVEL_READERACCESS = "org.imixs.ACCESSLEVEL.READERACCESS";
    public static final String ACCESSLEVEL_AUTHORACCESS = "org.imixs.ACCESSLEVEL.AUTHORACCESS";
    public static final String ACCESSLEVEL_EDITORACCESS = "org.imixs.ACCESSLEVEL.EDITORACCESS";
    public static final String ACCESSLEVEL_MANAGERACCESS = "org.imixs.ACCESSLEVEL.MANAGERACCESS";
    public static final String EVENTLOG_TOPIC_INDEX_ADD = "index.add";
    public static final String EVENTLOG_TOPIC_INDEX_REMOVE = "index.remove";
    public static final String READACCESS = "$readaccess";
    public static final String WRITEACCESS = "$writeaccess";
    public static final String ISAUTHOR = "$isAuthor";
    public static final String NOINDEX = "$noindex";
    public static final String IMMUTABLE = "$immutable";
    public static final String VERSION = "$version";
    public static final String USER_GROUP_LIST = "org.imixs.USER.GROUPLIST";
    private static final Logger logger = Logger.getLogger(DocumentService.class.getName());
    public static final String OPERATION_NOTALLOWED = "OPERATION_NOTALLOWED";
    public static final String INVALID_PARAMETER = "INVALID_PARAMETER";
    public static final String INVALID_UNIQUEID = "INVALID_UNIQUEID";
    @Resource
    SessionContext ctx;
    @Resource(name="ACCESS_ROLES")
    private String accessRoles = "";
    @Resource(name="DISABLE_OPTIMISTIC_LOCKING")
    private Boolean disableOptimisticLocking = false;
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    @Inject
    private UpdateService indexUpdateService;
    @Inject
    private SearchService indexSearchService;
    @Inject
    private EventLogService eventLogService;
    @Inject
    protected Event<DocumentEvent> documentEvents;
    @Inject
    protected Event<UserGroupEvent> userGroupEvents;
    @Inject
    @ConfigProperty(name="index.defaultOperator", defaultValue="AND")
    private String indexDefaultOperator;

    public String getAccessRoles() {
        return this.accessRoles;
    }

    public void setAccessRoles(String accessRoles) {
        this.accessRoles = accessRoles;
    }

    public void setDisableOptimisticLocking(Boolean disableOptimisticLocking) {
        this.disableOptimisticLocking = disableOptimisticLocking;
    }

    public Boolean getDisableOptimisticLocking() {
        return this.disableOptimisticLocking;
    }

    public List<String> getUserNameList() {
        Vector<String> userNameList = new Vector<String>();
        userNameList.add(this.ctx.getCallerPrincipal().getName().toString());
        String roleList = "org.imixs.ACCESSLEVEL.READERACCESS,org.imixs.ACCESSLEVEL.AUTHORACCESS,org.imixs.ACCESSLEVEL.EDITORACCESS,org.imixs.ACCESSLEVEL.MANAGERACCESS," + this.accessRoles;
        StringTokenizer roleListTokens = new StringTokenizer(roleList, ",");
        while (roleListTokens.hasMoreTokens()) {
            try {
                String testRole = roleListTokens.nextToken().trim();
                if ("".equals(testRole) || !this.ctx.isCallerInRole(testRole)) continue;
                userNameList.add(testRole);
            }
            catch (Exception testRole) {}
        }
        if (this.userGroupEvents != null) {
            UserGroupEvent groupEvent = new UserGroupEvent(this.ctx.getCallerPrincipal().getName().toString());
            this.userGroupEvents.fire((Object)groupEvent);
            if (groupEvent.getGroups() != null) {
                userNameList.addAll(groupEvent.getGroups());
            }
        } else {
            logger.warning("Missing CDI support for Event<UserGroupEvent> !");
        }
        return userNameList;
    }

    public boolean isUserContained(List<String> nameList) {
        if (nameList == null) {
            return false;
        }
        List<String> userNameList = this.getUserNameList();
        for (String aName : nameList) {
            if (aName == null || aName.isEmpty()) continue;
            if (!userNameList.stream().anyMatch(aName::equals)) continue;
            return true;
        }
        return false;
    }

    public boolean isUserInRole(String rolename) {
        try {
            return this.ctx.isCallerInRole(rolename);
        }
        catch (Exception e) {
            return false;
        }
    }

    public ItemCollection save(ItemCollection document) throws AccessDeniedException {
        Calendar cal;
        boolean debug = logger.isLoggable(Level.FINE);
        long lSaveTime = System.currentTimeMillis();
        if (debug) {
            logger.finest("......save - ID=" + document.getUniqueID() + ", provided version=" + document.getItemValueInteger(VERSION));
        }
        Document persistedDocument = null;
        this.manager.setFlushMode(FlushModeType.COMMIT);
        String sID = document.getItemValueString("$uniqueid");
        if (!sID.isEmpty()) {
            persistedDocument = (Document)this.manager.find(Document.class, (Object)sID);
            if (debug && persistedDocument == null) {
                logger.finest("......Document '" + sID + "' not found!");
            }
        }
        if (persistedDocument == null) {
            if (!(this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS))) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "You are not allowed to perform this operation");
            }
            persistedDocument = new Document(sID);
            Date datCreated = document.getItemValueDate("$created");
            if (datCreated != null) {
                cal = Calendar.getInstance();
                cal.setTime(datCreated);
                persistedDocument.setCreated(cal);
            }
            if (debug) {
                logger.finest("......persist activeEntity");
            }
            this.manager.persist((Object)persistedDocument);
        } else {
            if (!this.isCallerAuthor(persistedDocument) || !this.isCallerReader(persistedDocument)) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "You are not allowed to perform this operation");
            }
            if (ItemCollection.createByReference(persistedDocument.getData()).getItemValueBoolean(IMMUTABLE)) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "Operation not allowed, document is immutable!");
            }
        }
        if (debug) {
            logger.finest("......save - ID=" + document.getUniqueID() + " managed version=" + persistedDocument.getVersion());
        }
        document.removeItem(ISAUTHOR);
        String aType = document.getItemValueString("type");
        if ("".equals(aType)) {
            aType = "document";
            document.replaceItemValue("type", (Object)aType);
        }
        persistedDocument.setType(aType);
        document.replaceItemValue("$uniqueid", (Object)persistedDocument.getId());
        document.replaceItemValue("$created", (Object)persistedDocument.getCreated().getTime());
        cal = Calendar.getInstance();
        persistedDocument.setModified(cal);
        document.replaceItemValue("$modified", (Object)cal.getTime());
        if (this.documentEvents != null) {
            this.documentEvents.fire((Object)new DocumentEvent(document, 1));
        } else {
            logger.warning("Missing CDI support for Event<DocumentEvent> !");
        }
        if (!persistedDocument.getId().equals(document.getUniqueID()) || !persistedDocument.getCreated().getTime().equals(document.getItemValueDate("$created"))) {
            throw new InvalidAccessException("INVALID_ID", "Invalid data after DocumentEvent 'ON_DOCUMENT_SAVE'.");
        }
        if (this.disableOptimisticLocking.booleanValue()) {
            document.removeItem("$Version");
        }
        if (!this.disableOptimisticLocking.booleanValue() && document.hasItem(VERSION) && document.getItemValueInteger(VERSION) > 0) {
            int version = document.getItemValueInteger(VERSION);
            persistedDocument.setVersion(version);
        }
        ItemCollection clone = (ItemCollection)document.clone();
        persistedDocument.setData(clone.getAllItems());
        document.removeItem(VERSION);
        document.replaceItemValue(ISAUTHOR, (Object)this.isCallerAuthor(persistedDocument));
        if (!document.getItemValueBoolean(NOINDEX)) {
            this.addDocumentToIndex(document);
        } else {
            this.removeDocumentFromIndex(document.getUniqueID());
        }
        persistedDocument.setPending(true);
        if (debug) {
            logger.fine("...'" + document.getUniqueID() + "' saved in " + (System.currentTimeMillis() - lSaveTime) + "ms");
        }
        return document;
    }

    public void addDocumentToIndex(ItemCollection document) {
        if (!document.getItemValueBoolean(NOINDEX)) {
            this.eventLogService.createEvent(EVENTLOG_TOPIC_INDEX_ADD, document.getUniqueID());
        }
    }

    public void removeDocumentFromIndex(String uniqueID) {
        boolean debug = logger.isLoggable(Level.FINE);
        long ltime = System.currentTimeMillis();
        this.eventLogService.createEvent(EVENTLOG_TOPIC_INDEX_REMOVE, uniqueID);
        if (debug) {
            logger.fine("... update eventLog cache in " + (System.currentTimeMillis() - ltime) + " ms (1 document to be removed)");
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection saveByNewTransaction(ItemCollection itemcol) throws AccessDeniedException {
        return this.save(itemcol);
    }

    public ItemCollection load(String id) {
        boolean debug = logger.isLoggable(Level.FINE);
        long lLoadTime = System.currentTimeMillis();
        Document persistedDocument = null;
        if (id == null || id.isEmpty()) {
            return null;
        }
        persistedDocument = (Document)this.manager.find(Document.class, (Object)id);
        if (persistedDocument != null && this.isCallerReader(persistedDocument)) {
            ItemCollection result = null;
            if (persistedDocument.isPending()) {
                if (debug) {
                    logger.finest("......clone manged entity '" + id + "' pending status=" + persistedDocument.isPending());
                }
                result = new ItemCollection(persistedDocument.getData());
            } else {
                result = new ItemCollection();
                result.setAllItems(persistedDocument.getData());
                this.manager.detach((Object)persistedDocument);
            }
            this.updateMetaData(result, persistedDocument);
            if (this.documentEvents != null) {
                this.documentEvents.fire((Object)new DocumentEvent(result, 2));
            } else {
                logger.warning("Missing CDI support for Event<DocumentEvent> !");
            }
            if (debug) {
                logger.fine("...'" + result.getUniqueID() + "' loaded in " + (System.currentTimeMillis() - lLoadTime) + "ms");
            }
            return result;
        }
        return null;
    }

    public void remove(ItemCollection document) throws AccessDeniedException {
        if (document == null) {
            return;
        }
        Document persistedDocument = null;
        String sID = document.getItemValueString("$uniqueid");
        persistedDocument = (Document)this.manager.find(Document.class, (Object)sID);
        if (persistedDocument != null) {
            if (!this.isCallerReader(persistedDocument) || !this.isCallerAuthor(persistedDocument)) {
                throw new AccessDeniedException(OPERATION_NOTALLOWED, "remove - You are not allowed to perform this operation");
            }
            if (this.documentEvents != null) {
                this.documentEvents.fire((Object)new DocumentEvent(document, 3));
            } else {
                logger.warning("Missing CDI support for Event<DocumentEvent> !");
            }
            this.manager.remove((Object)persistedDocument);
            if (!document.getItemValueBoolean(NOINDEX)) {
                this.removeDocumentFromIndex(document.getUniqueID());
            }
        } else {
            throw new AccessDeniedException(INVALID_UNIQUEID, "remove - invalid $uniqueid");
        }
    }

    public int count(String searchTerm) throws QueryException {
        return this.count(searchTerm, 0);
    }

    public int count(String sSearchTerm, int maxResult) throws QueryException {
        this.indexUpdateService.updateIndex();
        return this.indexSearchService.getTotalHits(sSearchTerm, maxResult, null);
    }

    public int countPages(String searchTerm, int pageSize) throws QueryException {
        double pages = 1.0;
        double count = this.count(searchTerm);
        if (count > 0.0) {
            pages = Math.ceil(count / (double)pageSize);
        }
        return (int)pages;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<ItemCollection> find(String searchTerm, int pageSize, int pageIndex) throws QueryException {
        return this.find(searchTerm, pageSize, pageIndex, null, false);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<ItemCollection> find(String searchTerm, int pageSize, int pageIndex, String sortBy, boolean sortReverse) throws QueryException {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("......find - SearchTerm=" + searchTerm + "  , pageSize=" + pageSize + " pageNumber=" + pageIndex + " , sortBy=" + sortBy + " reverse=" + sortReverse);
        }
        SortOrder sortOrder = null;
        if (sortBy != null && !sortBy.isEmpty()) {
            sortOrder = new SortOrder(sortBy, sortReverse);
        }
        this.indexUpdateService.updateIndex();
        DefaultOperator defaultOperator = null;
        defaultOperator = this.indexDefaultOperator != null && "OR".equals(this.indexDefaultOperator.toUpperCase()) ? DefaultOperator.OR : DefaultOperator.AND;
        return this.indexSearchService.search(searchTerm, pageSize, pageIndex, sortOrder, defaultOperator, false);
    }

    public List<ItemCollection> findStubs(String searchTerm, int pageSize, int pageIndex, String sortBy, boolean sortReverse) throws QueryException {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("......find - SearchTerm=" + searchTerm + "  , pageSize=" + pageSize + " pageNumber=" + pageIndex + " , sortBy=" + sortBy + " reverse=" + sortReverse);
        }
        SortOrder sortOrder = null;
        if (sortBy != null && !sortBy.isEmpty()) {
            sortOrder = new SortOrder(sortBy, sortReverse);
        }
        this.indexUpdateService.updateIndex();
        DefaultOperator defaultOperator = null;
        defaultOperator = this.indexDefaultOperator != null && "OR".equals(this.indexDefaultOperator.toUpperCase()) ? DefaultOperator.OR : DefaultOperator.AND;
        return this.indexSearchService.search(searchTerm, pageSize, pageIndex, sortOrder, defaultOperator, true);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<ItemCollection> findDocumentsByRef(String uniqueIdRef, int pageSize, int pageIndex) {
        String searchTerm = "($uniqueidref:\"" + uniqueIdRef + "\")";
        try {
            return this.find(searchTerm, pageSize, pageIndex);
        }
        catch (QueryException e) {
            logger.severe("findDocumentsByRef - invalid query: " + e.getMessage());
            return null;
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<ItemCollection> getDocumentsByType(String type) {
        if (type == null || type.isEmpty()) {
            throw new InvalidAccessException(INVALID_PARAMETER, "undefined type attribute");
        }
        String query = "SELECT document FROM Document AS document ";
        query = query + " WHERE document.type = '" + type + "'";
        query = query + " ORDER BY document.created DESC";
        return this.getDocumentsByQuery(query);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<ItemCollection> getDocumentsByQuery(String query) {
        return this.getDocumentsByQuery(query, -1);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<ItemCollection> getDocumentsByQuery(String query, int maxResult) {
        return this.getDocumentsByQuery(query, 0, maxResult);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public List<ItemCollection> getDocumentsByQuery(String query, int firstResult, int maxResult) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        Query q = this.manager.createQuery(query);
        if (maxResult > 0) {
            q.setMaxResults(maxResult);
        }
        if (firstResult > 0) {
            q.setFirstResult(firstResult);
        }
        long l = System.currentTimeMillis();
        List documentList = q.getResultList();
        if (documentList == null) {
            if (debug) {
                logger.finest("......getDocumentsByQuery - no ducuments found.");
            }
            return result;
        }
        for (Document doc : documentList) {
            if (!this.isCallerReader(doc)) continue;
            ItemCollection _tmp = null;
            if (doc.isPending()) {
                if (debug) {
                    logger.finest("......clone manged entity '" + doc.getId() + "' pending status=" + doc.isPending());
                }
                _tmp = new ItemCollection(doc.getData());
            } else {
                _tmp = new ItemCollection();
                _tmp.setAllItems(doc.getData());
                this.manager.detach((Object)doc);
            }
            this.updateMetaData(_tmp, doc);
            result.add(_tmp);
            if (this.documentEvents == null) continue;
            this.documentEvents.fire((Object)new DocumentEvent(_tmp, 2));
        }
        if (debug) {
            logger.fine("...getDocumentsByQuery - found " + documentList.size() + " documents in " + (System.currentTimeMillis() - l) + " ms");
        }
        return result;
    }

    public void backup(String query, String filePath) throws IOException, QueryException {
        boolean hasMoreData = true;
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        int pageIndex = 0;
        int icount = 0;
        logger.info("backup - starting...");
        logger.info("backup - query=" + query);
        logger.info("backup - target=" + filePath);
        if (filePath == null || filePath.isEmpty()) {
            logger.severe("Invalid FilePath!");
            return;
        }
        FileOutputStream fos = new FileOutputStream(filePath);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        while (hasMoreData) {
            List<ItemCollection> col = this.find(query, JUNK_SIZE, pageIndex);
            totalcount += (long)col.size();
            logger.info("backup - processing...... " + col.size() + " documents read....");
            if (col.size() < JUNK_SIZE) {
                hasMoreData = false;
                logger.finest("......all data read.");
            } else {
                ++pageIndex;
                logger.finest("......next page...");
            }
            for (ItemCollection aworkitem : col) {
                Map hmap = aworkitem.getAllItems();
                out.writeObject(hmap);
                ++icount;
            }
        }
        out.close();
        logger.info("backup - finished: " + icount + " documents read totaly.");
    }

    public void restore(String filePath) throws IOException {
        int JUNK_SIZE = 100;
        long totalcount = 0L;
        long errorCount = 0L;
        int icount = 0;
        FileInputStream fis = new FileInputStream(filePath);
        ObjectInputStream in = new ObjectInputStream(fis);
        logger.info("...starting restor form file " + filePath + "...");
        long l = System.currentTimeMillis();
        while (true) {
            try {
                while (true) {
                    Map hmap = (Map)in.readObject();
                    ItemCollection itemCol = new ItemCollection(hmap);
                    itemCol.removeItem(VERSION);
                    itemCol = ((DocumentService)this.ctx.getBusinessObject(DocumentService.class)).saveByNewTransaction(itemCol);
                    ++totalcount;
                    if (++icount < JUNK_SIZE) continue;
                    icount = 0;
                    logger.info("...restored " + totalcount + " document in " + (System.currentTimeMillis() - l) + "ms....");
                    l = System.currentTimeMillis();
                }
            }
            catch (EOFException eofe) {
            }
            catch (ClassNotFoundException e) {
                logger.warning("...error importing workitem at position " + (totalcount + ++errorCount) + " Error: " + e.getMessage());
                continue;
            }
            catch (AccessDeniedException e) {
                logger.warning("...error importing workitem at position " + (totalcount + ++errorCount) + " Error: " + e.getMessage());
                continue;
            }
            break;
        }
        in.close();
        String loginfo = "Import successfull! " + totalcount + " Entities imported. " + errorCount + " Errors.  Import FileName:" + filePath;
        logger.info(loginfo);
    }

    public boolean isAuthor(ItemCollection itemcol) {
        List writeAccessList = itemcol.getItemValue(WRITEACCESS);
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS) || this.ctx.isCallerInRole(ACCESSLEVEL_EDITORACCESS)) {
            return true;
        }
        return this.ctx.isCallerInRole(ACCESSLEVEL_AUTHORACCESS) && this.isUserContained(writeAccessList);
    }

    private void updateMetaData(ItemCollection itemColection, Document doc) {
        if (this.disableOptimisticLocking.booleanValue()) {
            itemColection.removeItem(VERSION);
        } else {
            itemColection.replaceItemValue(VERSION, (Object)doc.getVersion());
        }
        itemColection.replaceItemValue("$modified", (Object)doc.getModified().getTime());
        itemColection.replaceItemValue(ISAUTHOR, (Object)this.isCallerAuthor(doc));
    }

    private boolean isCallerReader(Document document) {
        ItemCollection itemcol = ItemCollection.createByReference(document.getData());
        List readAccessList = itemcol.getItemValue(READACCESS);
        if (this.ctx.isCallerInRole(ACCESSLEVEL_NOACCESS)) {
            return false;
        }
        if (this.ctx.isCallerInRole(ACCESSLEVEL_MANAGERACCESS)) {
            return true;
        }
        return this.isEmptyList(readAccessList) || this.isUserContained(readAccessList);
    }

    private boolean isCallerAuthor(Document document) {
        ItemCollection itemcol = ItemCollection.createByReference(document.getData());
        return this.isAuthor(itemcol);
    }

    public boolean isEmptyList(List<String> aList) {
        if (aList == null || aList.size() == 0) {
            return true;
        }
        for (String aEntry : aList) {
            if (aEntry == null || aEntry.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

