/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.jpa.EventLog;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RolesAllowed(value={"org.imixs.ACCESSLEVEL.NOACCESS", "org.imixs.ACCESSLEVEL.READERACCESS", "org.imixs.ACCESSLEVEL.AUTHORACCESS", "org.imixs.ACCESSLEVEL.EDITORACCESS", "org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@LocalBean
public class EventLogService {
    public static final String EVENTLOG_LOCK_DATE = "eventlog.lock.date";
    @PersistenceContext(unitName="org.imixs.workflow.jpa")
    private EntityManager manager;
    private static Logger logger = Logger.getLogger(EventLogService.class.getName());

    public EventLog createEvent(String topic, String refID) {
        return this.createEvent(topic, refID, (Map<String, List<Object>>)null, null);
    }

    public EventLog createEvent(String topic, String refID, Calendar timeout) {
        return this.createEvent(topic, refID, (Map<String, List<Object>>)null, timeout);
    }

    public EventLog createEvent(String topic, String refID, ItemCollection document) {
        return this.createEvent(topic, refID, document.getAllItems(), null);
    }

    public EventLog createEvent(String topic, String refID, ItemCollection document, Calendar timeout) {
        return this.createEvent(topic, refID, document.getAllItems(), timeout);
    }

    public EventLog createEvent(String topic, String refID, Map<String, List<Object>> data, Calendar timeout) {
        boolean debug = logger.isLoggable(Level.FINE);
        if (refID == null || refID.isEmpty()) {
            logger.warning("create EventLog failed - given ref-id is empty!");
            return null;
        }
        this.manager.setFlushMode(FlushModeType.COMMIT);
        EventLog eventLog = new EventLog(topic, refID, data);
        if (timeout != null) {
            eventLog.setTimeout(timeout);
        }
        this.manager.persist((Object)eventLog);
        if (debug) {
            logger.finest("......created new eventLog '" + refID + "' => " + topic);
        }
        return eventLog;
    }

    public List<EventLog> findEventsByTopic(int maxCount, String ... topic) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<EventLog> result = new ArrayList();
        String query = "SELECT eventlog FROM EventLog AS eventlog ";
        query = query + "WHERE (";
        for (String _topic : topic) {
            if (_topic == null || _topic.isEmpty()) continue;
            query = query + "eventlog.topic = '" + _topic + "' OR ";
        }
        query = query.substring(0, query.length() - 3);
        query = query + ") ORDER BY eventlog.created ASC";
        Query q = this.manager.createQuery(query);
        q.setMaxResults(maxCount);
        result = q.getResultList();
        if (debug) {
            logger.fine("found " + result.size() + " event for topic " + topic);
        }
        return result;
    }

    public List<EventLog> findEventsByTimeout(int maxCount, String ... topic) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<EventLog> result = new ArrayList();
        String query = "SELECT eventlog FROM EventLog AS eventlog ";
        query = query + "WHERE (eventlog.timeout <= :now) AND ";
        query = query + " (";
        for (String _topic : topic) {
            if (_topic == null || _topic.isEmpty()) continue;
            query = query + "eventlog.topic = '" + _topic + "' OR ";
        }
        query = query.substring(0, query.length() - 3);
        query = query + ") ORDER BY eventlog.created ASC";
        Query q = this.manager.createQuery(query);
        q.setParameter("now", new Date(), TemporalType.TIMESTAMP);
        q.setMaxResults(maxCount);
        result = q.getResultList();
        if (debug) {
            logger.fine("found " + result.size() + " event for topic " + topic);
        }
        return result;
    }

    public List<EventLog> findEventsByRef(int maxCount, String ref, String ... topic) {
        boolean debug = logger.isLoggable(Level.FINE);
        List result = null;
        String query = "SELECT eventlog FROM EventLog AS eventlog ";
        query = query + "WHERE (eventlog.ref = '" + ref + "' AND (";
        for (String _topic : topic) {
            query = query + "eventlog.topic = '" + _topic + "' OR ";
        }
        query = query.substring(0, query.length() - 3);
        query = query + ") ORDER BY eventlog.created ASC";
        Query q = this.manager.createQuery(query);
        q.setMaxResults(maxCount);
        result = q.getResultList();
        if (debug) {
            logger.fine("found " + result.size() + " event for topic " + topic);
        }
        return result;
    }

    public List<EventLog> findAllEvents(int firstResult, int maxResult) {
        boolean debug = logger.isLoggable(Level.FINE);
        ArrayList<EventLog> result = new ArrayList();
        String query = "SELECT eventlog FROM EventLog AS eventlog ";
        query = query + " ORDER BY eventlog.created ASC";
        Query q = this.manager.createQuery(query);
        if (maxResult > 0) {
            q.setMaxResults(maxResult);
        }
        if (firstResult > 0) {
            q.setFirstResult(firstResult);
        }
        result = q.getResultList();
        if (debug) {
            logger.fine("found " + result.size() + " event log entries");
        }
        return result;
    }

    public void removeEvent(EventLog _eventLog) {
        block4: {
            boolean debug = logger.isLoggable(Level.FINE);
            EventLog eventLog = _eventLog;
            if (eventLog != null && !this.manager.contains((Object)eventLog)) {
                eventLog = (EventLog)this.manager.find(EventLog.class, (Object)eventLog.getId());
            }
            if (eventLog != null) {
                try {
                    this.manager.remove((Object)eventLog);
                }
                catch (OptimisticLockException e) {
                    if (!debug) break block4;
                    logger.finest(e.getMessage());
                }
            }
        }
    }

    public void removeEvent(String id) {
        block3: {
            EventLog eventLog = null;
            boolean debug = logger.isLoggable(Level.FINE);
            eventLog = (EventLog)this.manager.find(EventLog.class, (Object)id);
            if (eventLog != null) {
                try {
                    this.manager.remove((Object)eventLog);
                }
                catch (OptimisticLockException e) {
                    if (!debug) break block3;
                    logger.finest(e.getMessage());
                }
            }
        }
    }

    public EventLog getEvent(String id) {
        EventLog eventLog = (EventLog)this.manager.find(EventLog.class, (Object)id);
        this.manager.detach((Object)eventLog);
        return eventLog;
    }

    public boolean lock(EventLog _eventLogEntry) {
        EventLog eventLog = (EventLog)this.manager.find(EventLog.class, (Object)_eventLogEntry.getId());
        if (eventLog != null) {
            if (eventLog.getTopic().equals(_eventLogEntry.getTopic())) {
                eventLog.setTopic(_eventLogEntry.getTopic() + ".lock");
                ItemCollection data = new ItemCollection(eventLog.getData());
                data.setItemValue(EVENTLOG_LOCK_DATE, (Object)new Date());
                this.manager.merge((Object)eventLog);
                return true;
            }
            logger.warning("unable to lock eventLogEntry '" + _eventLogEntry.getId() + "' - already locked!");
        }
        return false;
    }

    public boolean unlock(EventLog _eventLogEntry) {
        EventLog eventLog = _eventLogEntry;
        if (eventLog != null && !this.manager.contains((Object)eventLog)) {
            eventLog = (EventLog)this.manager.find(EventLog.class, (Object)eventLog.getId());
        }
        if (eventLog != null) {
            if (eventLog.getTopic().equals(_eventLogEntry.getTopic())) {
                eventLog.setTopic(eventLog.getTopic().substring(0, eventLog.getTopic().lastIndexOf(".lock")));
                ItemCollection data = new ItemCollection(eventLog.getData());
                data.removeItem(EVENTLOG_LOCK_DATE);
                this.manager.merge((Object)eventLog);
                return true;
            }
            logger.warning("unable to lock eventLogEntry '" + _eventLogEntry.getId() + "' - already locked!");
        }
        return false;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void releaseDeadLocks(long deadLockInterval, String ... topic) {
        for (int i = 0; i < topic.length; ++i) {
            topic[i] = topic[i] + ".lock";
        }
        List<EventLog> events = this.findEventsByTopic(100, topic);
        Date now = new Date();
        for (EventLog eventLogEntry : events) {
            ItemCollection data = new ItemCollection(eventLogEntry.getData());
            Date lockDate = data.getItemValueDate(EVENTLOG_LOCK_DATE);
            long age = 0L;
            if (lockDate != null) {
                age = now.getTime() - lockDate.getTime();
                if (age <= deadLockInterval) continue;
                logger.warning("Deadlock detected! - eventlog.id=" + eventLogEntry.getId() + " will be unlocked! (deadlock since " + age + "ms)");
                this.unlock(eventLogEntry);
                continue;
            }
            logger.warning("Invalid Deadlock state detected, missing lock date! - eventlog.id=" + eventLogEntry.getId() + " will be deleted");
            this.removeEvent(eventLogEntry.getId());
        }
    }
}

