/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.adminp;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.LocalBean;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.adminp.AdminPException;
import org.imixs.workflow.engine.adminp.JobHandler;

@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@Stateless
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
@LocalBean
public class JobHandlerUpgradeWorkitems
implements JobHandler {
    private static final int DEFAULT_BLOCK_SIZE = 100;
    @Resource
    SessionContext ctx;
    @Inject
    DocumentService documentService;
    private static Logger logger = Logger.getLogger(JobHandlerUpgradeWorkitems.class.getName());

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public ItemCollection run(ItemCollection adminp) throws AdminPException {
        long lProfiler = System.currentTimeMillis();
        int iIndex = adminp.getItemValueInteger("numIndex");
        int iBlockSize = adminp.getItemValueInteger("numBlockSize");
        if (iBlockSize <= 0) {
            iBlockSize = 100;
            adminp.replaceItemValue("numBlockSize", (Object)iBlockSize);
        }
        int iUpdates = adminp.getItemValueInteger("numUpdates");
        int iProcessed = adminp.getItemValueInteger("numProcessed");
        String query = this.buildQuery(adminp);
        logger.finest("......JQPL query: " + query);
        adminp.replaceItemValue("txtQuery", (Object)query);
        logger.info("... selecting workitems...");
        List<ItemCollection> workitemList = this.documentService.getDocumentsByQuery(query, iIndex, iBlockSize);
        int colSize = workitemList.size();
        logger.info("Job UPGRADE (" + adminp.getUniqueID() + ") - verifeing " + colSize + " workitems...");
        int iCount = 0;
        for (ItemCollection workitem : workitemList) {
            if (!workitem.hasItem("$modelversion") || !this.upgradeWorkitem(workitem)) continue;
            logger.info("...upgrade '" + workitem.getUniqueID() + "' ...");
            this.documentService.saveByNewTransaction(workitem);
            ++iCount;
        }
        adminp.replaceItemValue("numUpdates", (Object)(iUpdates += iCount));
        adminp.replaceItemValue("numProcessed", (Object)(iProcessed += colSize));
        adminp.replaceItemValue("numIndex", (Object)(iIndex += colSize));
        long time = (System.currentTimeMillis() - lProfiler) / 1000L;
        if (time == 0L) {
            time = 1L;
        }
        logger.info("Job UPGRADE (" + adminp.getUniqueID() + ") - " + colSize + " documents processed, " + iCount + " updates in " + time + " sec.  (in total: " + iProcessed + " processed, " + iUpdates + " updates)");
        if (colSize < iBlockSize) {
            adminp.replaceItemValue("iscompleted", (Object)true);
        }
        return adminp;
    }

    public boolean upgradeWorkitem(ItemCollection workitem) {
        boolean bUpgrade = false;
        if (workitem.getItemValueBoolean("$immutable")) {
            return false;
        }
        if (!workitem.hasItem("$workflowGroup")) {
            workitem.replaceItemValue("$workflowGroup", (Object)workitem.getItemValue("txtworkflowgroup"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$workflowStatus")) {
            workitem.replaceItemValue("$workflowStatus", (Object)workitem.getItemValue("txtworkflowstatus"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$lastEvent")) {
            workitem.replaceItemValue("$lastEvent", (Object)workitem.getItemValue("numlastactivityid"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$lastEventDate")) {
            workitem.replaceItemValue("$lastEventDate", (Object)workitem.getItemValue("timworkflowlastaccess"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$creator")) {
            workitem.replaceItemValue("$creator", (Object)workitem.getItemValue("namcreator"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$taskid")) {
            workitem.replaceItemValue("$taskid", (Object)workitem.getItemValue("$processid"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("$owner")) {
            workitem.replaceItemValue("$owner", (Object)workitem.getItemValue("namowner"));
            bUpgrade = true;
        }
        if (!workitem.hasItem("process.name")) {
            workitem.replaceItemValue("process.name", (Object)workitem.getItemValue("txtprocessname"));
            workitem.replaceItemValue("process.ref", (Object)workitem.getItemValue("txtprocessRef"));
            workitem.replaceItemValue("space.name", (Object)workitem.getItemValue("txtspacename"));
            workitem.replaceItemValue("space.ref", (Object)workitem.getItemValue("txtspaceRef"));
            workitem.replaceItemValue("space.assist", (Object)workitem.getItemValue("namspaceassist"));
            workitem.replaceItemValue("space.team", (Object)workitem.getItemValue("namspaceTeam"));
            workitem.replaceItemValue("space.manager", (Object)workitem.getItemValue("namspaceManager"));
            workitem.replaceItemValue("process.assist", (Object)workitem.getItemValue("namprocessassist"));
            workitem.replaceItemValue("process.team", (Object)workitem.getItemValue("namprocessTeam"));
            workitem.replaceItemValue("process.manager", (Object)workitem.getItemValue("namprocessManager"));
            bUpgrade = true;
        }
        return bUpgrade;
    }

    private String buildQuery(ItemCollection adminp) {
        Date datFilterFrom = adminp.getItemValueDate("datfrom");
        Date datFilterTo = adminp.getItemValueDate("datto");
        String typeFilter = adminp.getItemValueString("typelist");
        SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean bAddAnd = false;
        String query = "SELECT document FROM Document AS document ";
        query = query + "WHERE document.type NOT IN ('event') ";
        query = query + "AND document.type NOT LIKE 'snapshot%' ";
        query = query + "AND document.type NOT LIKE 'workitemlob%' ";
        if (typeFilter != null && !typeFilter.isEmpty()) {
            List<String> typeList = Arrays.asList(typeFilter.split("\\s*,\\s*"));
            String sType = "";
            for (String aValue : typeList) {
                sType = sType + "'" + aValue.trim() + "',";
            }
            sType = sType.substring(0, sType.length() - 1);
            query = query + " AND document.type IN(" + sType + ")";
            bAddAnd = true;
        } else {
            query = query + " AND document.type IN('workitem')";
            bAddAnd = true;
        }
        if (datFilterFrom != null) {
            if (bAddAnd) {
                query = query + " AND ";
            }
            query = query + " document.created>='" + isoFormat.format(datFilterFrom) + "' ";
            bAddAnd = true;
        }
        if (datFilterTo != null) {
            if (bAddAnd) {
                query = query + " AND ";
            }
            query = query + " document.created<='" + isoFormat.format(datFilterTo) + "' ";
            bAddAnd = true;
        }
        query = query + " ORDER BY document.created";
        return query;
    }
}

