/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.exceptions.QueryException;

@Singleton
public class SchemaService {
    public static final String ANONYMOUS = "ANONYMOUS";
    @Inject
    @ConfigProperty(name="index.fields")
    Optional<String> indexFields;
    @Inject
    @ConfigProperty(name="index.fields.analyze")
    Optional<String> indexFieldsAnalyze;
    @Inject
    @ConfigProperty(name="index.fields.noanalyze")
    Optional<String> indexFieldsNoAnalyze;
    @Inject
    @ConfigProperty(name="index.fields.store")
    Optional<String> indexFieldsStore;
    @Inject
    private DocumentService documentService;
    private List<String> fieldList = null;
    private List<String> fieldListAnalyze = null;
    private List<String> fieldListNoAnalyze = null;
    private List<String> fieldListStore = null;
    private Set<String> uniqueFieldList = null;
    public static List<String> DEFAULT_SEARCH_FIELD_LIST = Arrays.asList("$workflowsummary", "$workflowabstract");
    public static List<String> DEFAULT_NOANALYZE_FIELD_LIST = Arrays.asList("$modelversion", "$taskid", "$processid", "$workitemid", "$uniqueidref", "type", "$writeaccess", "$snapshotid", "$modified", "$created", "namcreator", "$creator", "$editor", "$lasteditor", "$workflowgroup", "$workflowstatus", "txtworkflowgroup", "name", "txtname", "$owner", "namowner", "txtworkitemref", "$workitemref", "$uniqueidsource", "$uniqueidversions", "$lasttask", "$lastevent", "$lasteventdate", "$file.count", "$file.names");
    public static List<String> DEFAULT_STORE_FIELD_LIST = Arrays.asList("type", "$taskid", "$writeaccess", "$snapshotid", "$modelversion", "$workflowsummary", "$workflowabstract", "$workflowgroup", "$workflowstatus", "$modified", "$created", "$lasteventdate", "$creator", "$editor", "$lasteditor", "$owner", "namowner");
    private static Logger logger = Logger.getLogger(SchemaService.class.getName());

    @PostConstruct
    void init() {
        String sName;
        StringTokenizer st;
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("......lucene FulltextFieldList=" + this.indexFields);
            logger.finest("......lucene IndexFieldListAnalyze=" + this.indexFieldsAnalyze);
            logger.finest("......lucene IndexFieldListNoAnalyze=" + this.indexFieldsNoAnalyze);
            logger.finest("......lucene IndexFieldListStore=" + this.indexFieldsStore);
        }
        this.fieldList = new ArrayList<String>();
        this.fieldList.addAll(DEFAULT_SEARCH_FIELD_LIST);
        if (this.indexFields.isPresent() && !this.indexFields.get().isEmpty()) {
            st = new StringTokenizer(this.indexFields.get(), ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName) || this.fieldList.contains(sName)) continue;
                this.fieldList.add(sName);
            }
        }
        this.fieldListNoAnalyze = new ArrayList<String>();
        this.fieldListNoAnalyze.addAll(DEFAULT_NOANALYZE_FIELD_LIST);
        if (this.indexFieldsNoAnalyze.isPresent() && !this.indexFieldsNoAnalyze.get().isEmpty()) {
            st = new StringTokenizer(this.indexFieldsNoAnalyze.get(), ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName) || this.fieldListNoAnalyze.contains(sName)) continue;
                this.fieldListNoAnalyze.add(sName);
            }
        }
        this.fieldListAnalyze = new ArrayList<String>();
        if (this.indexFieldsAnalyze.isPresent() && !this.indexFieldsAnalyze.get().isEmpty()) {
            st = new StringTokenizer(this.indexFieldsAnalyze.get(), ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if ("$uniqueid".equals(sName) || "$readaccess".equals(sName) || this.fieldListAnalyze.contains(sName) || this.fieldListNoAnalyze.contains(sName)) continue;
                this.fieldListAnalyze.add(sName);
            }
        }
        this.fieldListStore = new ArrayList<String>();
        this.fieldListStore.addAll(DEFAULT_STORE_FIELD_LIST);
        if (this.indexFieldsStore.isPresent() && !this.indexFieldsStore.get().isEmpty()) {
            st = new StringTokenizer(this.indexFieldsStore.get(), ",");
            while (st.hasMoreElements()) {
                sName = st.nextToken().toLowerCase().trim();
                if (this.fieldListStore.contains(sName)) continue;
                this.fieldListStore.add(sName);
            }
        }
        for (String fieldName : this.fieldListStore) {
            if (this.fieldListAnalyze.contains(fieldName) || this.fieldListNoAnalyze.contains(fieldName)) continue;
            this.fieldListAnalyze.add(fieldName);
        }
        this.uniqueFieldList = new HashSet<String>();
        this.uniqueFieldList.add("$uniqueid");
        this.uniqueFieldList.add("$readaccess");
        this.uniqueFieldList.addAll(this.fieldListStore);
        this.uniqueFieldList.addAll(this.fieldListAnalyze);
        this.uniqueFieldList.addAll(this.fieldListNoAnalyze);
    }

    public List<String> getFieldList() {
        return this.fieldList;
    }

    public List<String> getFieldListAnalyze() {
        return this.fieldListAnalyze;
    }

    public List<String> getFieldListNoAnalyze() {
        return this.fieldListNoAnalyze;
    }

    public List<String> getFieldListStore() {
        return this.fieldListStore;
    }

    public Set<String> getUniqueFieldList() {
        return this.uniqueFieldList;
    }

    public ItemCollection getConfiguration() {
        ItemCollection config = new ItemCollection();
        config.replaceItemValue("lucence.fulltextFieldList", this.fieldList);
        config.replaceItemValue("lucence.indexFieldListAnalyze", this.fieldListAnalyze);
        config.replaceItemValue("lucence.indexFieldListNoAnalyze", this.fieldListNoAnalyze);
        config.replaceItemValue("lucence.indexFieldListStore", this.fieldListStore);
        return config;
    }

    public String getExtendedSearchTerm(String sSearchTerm) throws QueryException {
        if (sSearchTerm == null || "".equals(sSearchTerm)) {
            logger.warning("No search term provided!");
            return "";
        }
        if (!this.documentService.isUserInRole("org.imixs.ACCESSLEVEL.MANAGERACCESS")) {
            List<String> userNameList = this.documentService.getUserNameList();
            String sAccessTerm = "($readaccess:ANONYMOUS";
            for (String aRole : userNameList) {
                if ("".equals(aRole)) continue;
                sAccessTerm = sAccessTerm + " OR $readaccess:\"" + aRole + "\"";
            }
            sAccessTerm = sAccessTerm + ") AND ";
            sSearchTerm = sAccessTerm + sSearchTerm;
        }
        logger.finest("......lucene final searchTerm=" + sSearchTerm);
        return sSearchTerm;
    }

    public String escapeSearchTerm(String searchTerm, boolean ignoreBracket) {
        if (searchTerm == null || searchTerm.isEmpty()) {
            return searchTerm;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < searchTerm.length(); ++i) {
            char c = searchTerm.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append('\\');
            }
            if (!(ignoreBracket || c != '(' && c != ')')) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String escapeSearchTerm(String searchTerm) {
        return this.escapeSearchTerm(searchTerm, false);
    }

    public String normalizeSearchTerm(String searchTerm) {
        if (searchTerm == null) {
            return "";
        }
        if (searchTerm.trim().isEmpty()) {
            return "";
        }
        if (this.containsDigit(searchTerm = searchTerm.toLowerCase())) {
            return this.escapeSearchTerm(searchTerm, false);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < searchTerm.length(); ++i) {
            char c = searchTerm.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '?' || c == '|' || c == '&' || c == '/') {
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean containsDigit(String s) {
        boolean containsDigit = false;
        if (s != null && !s.isEmpty()) {
            char c;
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n && !(containsDigit = Character.isDigit(c = cArray[i])); ++i) {
            }
        }
        return containsDigit;
    }
}

