/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class ApproverPlugin
extends AbstractPlugin {
    private static Logger logger = Logger.getLogger(ApproverPlugin.class.getName());
    public static String APPROVEDBY = "$approvedby";
    public static String APPROVERS = "$approvers";
    private static String EVAL_APPROVEDBY = "approvedby";

    public ItemCollection run(ItemCollection workitem, ItemCollection event) throws PluginException {
        boolean refresh = false;
        boolean reset = false;
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(event, "item", workitem);
        if (evalItemCollection != null && evalItemCollection.hasItem(EVAL_APPROVEDBY)) {
            boolean debug = logger.isLoggable(Level.FINE);
            refresh = true;
            if ("false".equals(evalItemCollection.getItemValueString(EVAL_APPROVEDBY + ".refresh"))) {
                refresh = false;
            }
            if (debug) {
                logger.fine("refresh=" + refresh);
            }
            reset = false;
            if ("true".equals(evalItemCollection.getItemValueString(EVAL_APPROVEDBY + ".reset"))) {
                reset = true;
            }
            if (debug) {
                logger.fine("reset=" + reset);
            }
            List groups = evalItemCollection.getItemValue(EVAL_APPROVEDBY);
            for (String aGroup : groups) {
                List nameList = workitem.getItemValue(aGroup);
                nameList.removeIf(item -> item == null || "".equals(item));
                List newAppoverList = nameList.stream().distinct().collect(Collectors.toList());
                if (!workitem.hasItem(aGroup + APPROVERS) || reset) {
                    if (debug) {
                        logger.fine("creating new approver list: " + aGroup + "=" + newAppoverList);
                    }
                    workitem.replaceItemValue(aGroup + APPROVERS, newAppoverList);
                    workitem.removeItem(aGroup + APPROVEDBY);
                    continue;
                }
                if (refresh) {
                    this.refreshApprovers(workitem, aGroup);
                }
                String currentAppover = this.getWorkflowService().getUserName();
                List listApprovedBy = workitem.getItemValue(aGroup + APPROVEDBY);
                List listApprovers = workitem.getItemValue(aGroup + APPROVERS);
                if (debug) {
                    logger.fine("approved by:  " + currentAppover);
                }
                if (!listApprovers.contains(currentAppover) || listApprovedBy.contains(currentAppover)) continue;
                listApprovers.remove(currentAppover);
                listApprovedBy.add(currentAppover);
                listApprovers.removeIf(item -> item == null || "".equals(item));
                listApprovedBy.removeIf(item -> item == null || "".equals(item));
                workitem.replaceItemValue(aGroup + APPROVERS, (Object)listApprovers);
                workitem.replaceItemValue(aGroup + APPROVEDBY, (Object)listApprovedBy);
                if (!debug) continue;
                logger.fine("new list of approvedby: " + aGroup + "=" + listApprovedBy);
            }
        }
        return workitem;
    }

    void refreshApprovers(ItemCollection workitem, String sourceItem) {
        boolean debug = logger.isLoggable(Level.FINE);
        List nameList = workitem.getItemValue(sourceItem);
        nameList.removeIf(item -> item == null || "".equals(item));
        List newAppoverList = nameList.stream().distinct().collect(Collectors.toList());
        List listApprovedBy = workitem.getItemValue(sourceItem + APPROVEDBY);
        List listApprovers = workitem.getItemValue(sourceItem + APPROVERS);
        boolean update = false;
        for (String approver : newAppoverList) {
            if (listApprovedBy.contains(approver) || listApprovers.contains(approver)) continue;
            if (debug) {
                logger.fine("adding new approver to list '" + sourceItem + APPROVERS + "'");
            }
            listApprovers.add(approver);
            listApprovers.removeIf(item -> item == null || "".equals(item));
            update = true;
        }
        if (update) {
            if (debug) {
                logger.fine("updating approver list '" + sourceItem + APPROVERS + "'");
            }
            workitem.replaceItemValue(sourceItem + APPROVERS, (Object)listApprovers);
        }
    }
}

