/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.time.LocalDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.util.XMLParser;

public class IntervalPlugin
extends AbstractPlugin {
    public static final String EVAL_INTERVAL = "interval";
    public static final String INVALID_FORMAT = "INVALID_FORMAT";
    private ItemCollection documentContext;
    private static Logger logger = Logger.getLogger(IntervalPlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection event) throws PluginException {
        LocalDateTime result = null;
        this.documentContext = adocumentContext;
        if (!"1".equals(event.getItemValueString("keyScheduledActivity"))) {
            return this.documentContext;
        }
        Set fieldNames = this.documentContext.getAllItems().keySet();
        Optional<String> optional = fieldNames.stream().filter(x -> x.toLowerCase().startsWith("keyinterval")).findFirst();
        if (optional.isPresent()) {
            throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "Note: keyinterval is no longer supported by the intervalPlugin. Use instead a cron configuration.");
        }
        ItemCollection evalItemCollection = this.getWorkflowService().evalWorkflowResult(event, "item", adocumentContext, false);
        if (evalItemCollection == null) {
            return adocumentContext;
        }
        if (evalItemCollection.hasItem(EVAL_INTERVAL)) {
            String invervalDef = evalItemCollection.getItemValueString(EVAL_INTERVAL);
            if (invervalDef.trim().isEmpty()) {
                return adocumentContext;
            }
            ItemCollection processData = XMLParser.parseItemStructure((String)invervalDef);
            String cron = processData.getItemValueString("cron").trim().toLowerCase();
            String macro = processData.getItemValueString("macro").trim().toLowerCase();
            String ref = processData.getItemValueString("ref").trim().toLowerCase();
            if (!cron.isEmpty() && !macro.isEmpty()) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid interval configuration: cron and macro can not be combined!");
            }
            LocalDateTime refDate = this.documentContext.getItemValueLocalDateTime(ref);
            if (!macro.isEmpty() && refDate == null) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid interval configuration: ref item is missing for macro!");
            }
            logger.info("......cron=" + cron);
            logger.info("......macro=" + macro);
            logger.info("......ref=" + ref);
            result = !cron.isEmpty() ? this.evalCron(cron) : this.evalMacro(macro, refDate);
            if (result != null) {
                this.documentContext.replaceItemValue(ref, (Object)result);
            }
        }
        return this.documentContext;
    }

    public LocalDateTime evalCron(String cron) throws PluginException {
        LocalDateTime result;
        block20: {
            String[] cronDef = cron.split(" ");
            if (cronDef.length != 5) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid cron format: " + cron);
            }
            result = LocalDateTime.now().withSecond(0);
            boolean increase = true;
            try {
                String month;
                String dayofmonth;
                String hour;
                String minute = cronDef[0];
                if (minute.equals("*")) {
                    if (increase) {
                        increase = false;
                        result = result.plusMinutes(1L);
                    }
                } else {
                    result = result.withMinute(Integer.parseInt(minute));
                }
                if ((hour = cronDef[1]).equals("*")) {
                    if (increase) {
                        increase = false;
                        result = result.plusHours(1L);
                    }
                } else {
                    result = result.withHour(Integer.parseInt(hour));
                }
                if ((dayofmonth = cronDef[2]).equals("*")) {
                    if (increase) {
                        increase = false;
                        result = result.plusDays(1L);
                    }
                } else {
                    result = result.withDayOfMonth(Integer.parseInt(dayofmonth));
                }
                if ((month = cronDef[3]).equals("*")) {
                    if (increase) {
                        increase = false;
                        result = result.plusMonths(1L);
                    }
                } else {
                    result = result.withMonth(Integer.parseInt(month));
                }
            }
            catch (NumberFormatException e) {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid cron format: " + cron + " Note: we do not yet support all kind of patterns.");
            }
            String dayofweek = cronDef[4];
            if ("*".equals(dayofweek)) {
                if (increase) {
                    increase = false;
                    result = result.plusYears(1L);
                }
            } else {
                if (!dayofweek.startsWith("[")) {
                    dayofweek = "[" + dayofweek + "]";
                }
                int count = 0;
                do {
                    int dow = result.getDayOfWeek().getValue();
                    if (Pattern.compile(dayofweek).matcher("" + dow).find()) break block20;
                    result = result.plusDays(1L);
                } while (++count <= 7);
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid cron format 'DayOfWeek' : " + cron);
            }
        }
        return result;
    }

    public LocalDateTime evalMacro(String macro, LocalDateTime ldt) throws PluginException {
        switch (macro) {
            case "@yearly": {
                ldt = ldt.plusYears(1L);
                break;
            }
            case "@monthly": {
                ldt = ldt.plusMonths(1L);
                break;
            }
            case "@weekly": {
                ldt = ldt.plusWeeks(1L);
                break;
            }
            case "@daily": {
                ldt = ldt.plusDays(1L);
                break;
            }
            case "@hourly": {
                ldt = ldt.plusHours(1L);
                break;
            }
            default: {
                throw new PluginException(IntervalPlugin.class.getName(), INVALID_FORMAT, "invalid macro format: " + macro);
            }
        }
        return ldt;
    }
}

