/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;
import org.imixs.workflow.xml.XSLHandler;

public class MailPlugin
extends AbstractPlugin {
    public static final String ERROR_INVALID_XSL_FORMAT = "INVALID_XSL_FORMAT";
    public static final String ERROR_MAIL_MESSAGE = "ERROR_MAIL_MESSAGE";
    public static final String MAIL_SESSION_NAME = "mail/org.imixs.workflow.mail";
    public static final String CONTENTTYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENTTYPE_TEXT_HTML = "text/html";
    public static final String INVALID_ADDRESS = "INVALID_ADDRESS";
    @Resource(lookup="mail/org.imixs.workflow.mail")
    Session mailSession;
    @Inject
    @ConfigProperty(name="mail.testRecipients")
    Optional<String> mailTestRecipients;
    @Inject
    @ConfigProperty(name="mail.defaultSender")
    Optional<String> mailDefaultSender;
    @Inject
    @ConfigProperty(name="mail.charSet", defaultValue="ISO-8859-1")
    String mailCharSet;
    private MimeMessage mailMessage = null;
    private Multipart mimeMultipart = null;
    private String charSet = "ISO-8859-1";
    private boolean bHTMLMail = false;
    private static Logger logger = Logger.getLogger(MailPlugin.class.getName());

    public ItemCollection run(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        boolean debug = logger.isLoggable(Level.FINE);
        this.mailMessage = null;
        if (documentActivity.getItemValueBoolean("keyMailInactive") || "1".equals(documentActivity.getItemValueString("keyMailInactive"))) {
            if (debug) {
                logger.finest("......keyMailInactive = true - cancel mail message.");
            }
            return documentContext;
        }
        List<String> vectorRecipients = this.getRecipients(documentContext, documentActivity);
        if (vectorRecipients.isEmpty()) {
            if (debug) {
                logger.finest("......No Receipients defined for this Activity - cancel mail message.");
            }
            return documentContext;
        }
        try {
            this.initMailMessage();
            if (this.mailMessage == null) {
                logger.warning(" mailMessage = null");
                return documentContext;
            }
            InternetAddress adr = this.getInternetAddress(this.getFrom(documentContext, documentActivity));
            if (adr == null) {
                if (debug) {
                    logger.warning("...from address was resolved to null");
                }
                adr = new InternetAddress("");
            }
            this.mailMessage.setFrom((Address)adr);
            this.mailMessage.setRecipients(Message.RecipientType.TO, (Address[])this.getInternetAddressArray(vectorRecipients));
            this.mailMessage.setRecipients(Message.RecipientType.CC, (Address[])this.getInternetAddressArray(this.getRecipientsCC(documentContext, documentActivity)));
            this.mailMessage.setRecipients(Message.RecipientType.BCC, (Address[])this.getInternetAddressArray(this.getRecipientsBCC(documentContext, documentActivity)));
            String sReplyTo = this.getReplyTo(documentContext, documentActivity);
            if (sReplyTo != null && !sReplyTo.isEmpty()) {
                InternetAddress[] resplysAdrs = new InternetAddress[]{this.getInternetAddress(sReplyTo)};
                this.mailMessage.setReplyTo((Address[])resplysAdrs);
            }
            this.mailMessage.setSubject(this.getSubject(documentContext, documentActivity), this.getCharSet());
            String aBodyText = this.getBody(documentContext, documentActivity);
            MimeBodyPart messagePart = new MimeBodyPart();
            if (debug) {
                logger.finest("......ContentType: '" + this.getContentType() + "'");
            }
            messagePart.setContent((Object)aBodyText, this.getContentType());
            this.mimeMultipart.addBodyPart((BodyPart)messagePart);
        }
        catch (MessagingException e) {
            throw new PluginException(MailPlugin.class.getSimpleName(), ERROR_MAIL_MESSAGE, e.getMessage(), (Exception)((Object)e));
        }
        return documentContext;
    }

    @Override
    public void close(boolean rollbackTransaction) throws PluginException {
        if (!rollbackTransaction && this.mailSession != null && this.mailMessage != null) {
            boolean debug = logger.isLoggable(Level.FINE);
            try {
                if (this.mailTestRecipients.isPresent() && !this.mailTestRecipients.get().isEmpty()) {
                    Vector<String> vRecipients = new Vector<String>();
                    StringTokenizer st = new StringTokenizer(this.mailTestRecipients.get(), ",", false);
                    while (st.hasMoreElements()) {
                        vRecipients.add(st.nextToken().trim());
                    }
                    logger.info("Running in TestMode, forwarding mails to:");
                    for (String adr : vRecipients) {
                        logger.info("     " + adr);
                    }
                    try {
                        this.getMailMessage().setRecipients(Message.RecipientType.CC, null);
                        this.getMailMessage().setRecipients(Message.RecipientType.BCC, null);
                        this.getMailMessage().setRecipients(Message.RecipientType.TO, (Address[])this.getInternetAddressArray(vRecipients));
                        String sSubject = this.getMailMessage().getSubject();
                        this.getMailMessage().setSubject("[TESTMODE] : " + sSubject);
                    }
                    catch (MessagingException e) {
                        throw new PluginException(MailPlugin.class.getSimpleName(), INVALID_ADDRESS, " unable to set mail recipients: ", (Exception)((Object)e));
                    }
                }
                if (debug) {
                    logger.finest("......sending message...");
                }
                this.mailMessage.setContent((Object)this.mimeMultipart, this.getContentType());
                this.mailMessage.saveChanges();
                if (this.mailSession.getProperty("mail.smtp.password") != null && !this.mailSession.getProperty("mail.smtp.password").isEmpty()) {
                    Transport trans = this.mailSession.getTransport("smtp");
                    trans.connect(this.mailSession.getProperty("mail.smtp.user"), this.mailSession.getProperty("mail.smtp.password"));
                    trans.sendMessage((Message)this.mailMessage, this.mailMessage.getAllRecipients());
                    trans.close();
                } else {
                    long l = System.currentTimeMillis();
                    Transport trans = this.mailSession.getTransport("smtp");
                    trans.connect();
                    trans.sendMessage((Message)this.mailMessage, this.mailMessage.getAllRecipients());
                    trans.close();
                    if (debug) {
                        logger.finest("...mail transfer in " + (System.currentTimeMillis() - l) + "ms");
                    }
                }
                logger.info("...send mail: MessageID=" + this.mailMessage.getMessageID());
            }
            catch (Exception esend) {
                logger.warning("close failed with exception: " + esend.toString());
            }
        }
    }

    public String getFrom(ItemCollection documentContext, ItemCollection documentActivity) {
        boolean debug = logger.isLoggable(Level.FINE);
        String sFrom = documentActivity.getItemValueString("namMailFrom");
        if (sFrom.isEmpty() && this.mailDefaultSender.isPresent()) {
            sFrom = this.mailDefaultSender.get();
        }
        if (sFrom == null || sFrom.isEmpty()) {
            sFrom = this.getWorkflowService().getUserName();
        }
        if (debug) {
            logger.finest("......From: " + sFrom);
        }
        return sFrom;
    }

    public String getReplyTo(ItemCollection documentContext, ItemCollection documentActivity) {
        String sReplyTo = null;
        boolean debug = logger.isLoggable(Level.FINE);
        sReplyTo = "1".equals(documentActivity.getItemValueString("keyMailReplyToCurrentUser")) ? this.getWorkflowService().getUserName() : documentActivity.getItemValueString("namMailReplyToUser");
        if (debug) {
            logger.finest("......ReplyTo=" + sReplyTo);
        }
        return sReplyTo;
    }

    public String getSubject(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        boolean debug = logger.isLoggable(Level.FINE);
        String subject = this.getWorkflowService().adaptText(documentActivity.getItemValueString("txtMailSubject"), documentContext);
        if (debug) {
            logger.finest("......Subject: " + subject);
        }
        return subject;
    }

    public List<String> getRecipients(ItemCollection documentContext, ItemCollection documentActivity) {
        Vector<String> vectorRecipients = documentActivity.getItemValue("namMailReceiver");
        if (vectorRecipients == null) {
            vectorRecipients = new Vector<String>();
        }
        this.mergeFieldList(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFields"));
        if (logger.isLoggable(Level.FINE)) {
            logger.finest("......" + vectorRecipients.size() + " Receipients: ");
            for (String rez : vectorRecipients) {
                logger.finest("     " + rez);
            }
        }
        return vectorRecipients;
    }

    public List<String> getRecipientsCC(ItemCollection documentContext, ItemCollection documentActivity) {
        Vector<String> vectorRecipients = documentActivity.getItemValue("namMailReceiverCC");
        if (vectorRecipients == null) {
            vectorRecipients = new Vector<String>();
        }
        this.mergeFieldList(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFieldsCC"));
        if (logger.isLoggable(Level.FINE)) {
            logger.finest("......" + vectorRecipients.size() + " ReceipientsCC: ");
            for (String rez : vectorRecipients) {
                logger.finest("     " + rez);
            }
        }
        return vectorRecipients;
    }

    public List<String> getRecipientsBCC(ItemCollection documentContext, ItemCollection documentActivity) {
        Vector<String> vectorRecipients = documentActivity.getItemValue("namMailReceiverBCC");
        if (vectorRecipients == null) {
            vectorRecipients = new Vector<String>();
        }
        this.mergeFieldList(documentContext, vectorRecipients, documentActivity.getItemValue("keyMailReceiverFieldsBCC"));
        if (logger.isLoggable(Level.FINE)) {
            logger.finest("......" + vectorRecipients.size() + " ReceipientsBCC: ");
            for (String rez : vectorRecipients) {
                logger.finest("     " + rez);
            }
        }
        return vectorRecipients;
    }

    public String getBody(ItemCollection documentContext, ItemCollection documentActivity) throws PluginException {
        String aBodyText = this.getWorkflowService().adaptText(documentActivity.getItemValueString("rtfMailBody"), documentContext);
        String sTestHTML = aBodyText.trim().toLowerCase();
        this.bHTMLMail = sTestHTML.startsWith("<!doctype") || sTestHTML.startsWith("<html") || sTestHTML.startsWith("<?xml");
        if (sTestHTML.contains("<xsl:stylesheet")) {
            aBodyText = this.transformXSLBody(documentContext, aBodyText);
        }
        return aBodyText;
    }

    public String transformXSLBody(ItemCollection documentContext, String xslTemplate) throws PluginException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String encoding = "UTF-8";
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("......transfor mail body based on XSL template....");
        }
        try {
            XMLDocument xml = XMLDocumentAdapter.getDocument((ItemCollection)documentContext);
            StringWriter writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDocument.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.encoding", (Object)encoding);
            m.marshal((Object)xml, (Writer)writer);
            XSLHandler.transform((String)writer.toString(), (String)xslTemplate, (String)encoding, (OutputStream)outputStream);
            String string = outputStream.toString(encoding);
            return string;
        }
        catch (UnsupportedEncodingException | JAXBException | TransformerException e) {
            logger.warning("Error processing XSL template!");
            throw new PluginException(MailPlugin.class.getSimpleName(), ERROR_INVALID_XSL_FORMAT, e.getMessage(), (Exception)e);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void initMailMessage() throws AddressException, MessagingException {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("......initializeMailMessage...");
        }
        if (this.mailSession == null) {
            logger.warning(" Lookup MailSession 'mail/org.imixs.workflow.mail' failed: ");
            logger.warning(" Unable to send mails! Verify server resources -> mail session.");
        } else {
            if (this.mailCharSet != null && !this.mailCharSet.isEmpty()) {
                this.setCharSet(this.mailCharSet);
            }
            if (debug) {
                Properties props = this.mailSession.getProperties();
                Enumeration<Object> enumer = props.keys();
                while (enumer.hasMoreElements()) {
                    String aKey = enumer.nextElement().toString();
                    logger.finest("...... ProperyName= " + aKey);
                    String value = props.getProperty(aKey);
                    if (value == null) {
                        logger.finest("...... PropertyValue=null");
                        continue;
                    }
                    logger.finest("...... PropertyValue= " + props.getProperty(aKey).toString());
                }
            }
            this.mailMessage = new MimeMessage(this.mailSession);
            this.mailMessage.setSentDate(new Date());
            this.mailMessage.setFrom();
            this.mimeMultipart = new MimeMultipart();
        }
    }

    public InternetAddress getInternetAddress(String aAddr) throws AddressException {
        InternetAddress inetAddr = null;
        if (aAddr == null) {
            return null;
        }
        aAddr = aAddr.trim();
        try {
            inetAddr = aAddr.indexOf(" ") > -1 ? new InternetAddress("\"" + aAddr + "\"") : new InternetAddress(aAddr);
        }
        catch (AddressException ae) {
            ae.printStackTrace();
            return null;
        }
        return inetAddr;
    }

    private InternetAddress[] getInternetAddressArray(List aList) {
        InternetAddress inetAddr = null;
        if (aList == null) {
            return null;
        }
        Vector<InternetAddress> vReceipsTemp = new Vector<InternetAddress>();
        for (int i = 0; i < aList.size(); ++i) {
            try {
                inetAddr = this.getInternetAddress(aList.get(i).toString());
                if (inetAddr == null || "".equals(inetAddr.getAddress())) continue;
                vReceipsTemp.add(inetAddr);
                continue;
            }
            catch (AddressException addressException) {
                // empty catch block
            }
        }
        InternetAddress[] receipsAdrs = new InternetAddress[vReceipsTemp.size()];
        for (int i = 0; i < vReceipsTemp.size(); ++i) {
            receipsAdrs[i] = (InternetAddress)vReceipsTemp.elementAt(i);
        }
        return receipsAdrs;
    }

    public Session getMailSession() {
        return this.mailSession;
    }

    public Message getMailMessage() {
        return this.mailMessage;
    }

    public Multipart getMultipart() {
        return this.mimeMultipart;
    }

    public boolean isHTMLMail() {
        return this.bHTMLMail;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public String getContentType() {
        String sContentType = "";
        sContentType = this.bHTMLMail ? CONTENTTYPE_TEXT_HTML : CONTENTTYPE_TEXT_PLAIN;
        if (this.getCharSet() != null && !this.getCharSet().isEmpty()) {
            sContentType = sContentType + "; charset=" + this.getCharSet();
        }
        return sContentType;
    }
}

