/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.plugins;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.RuleEngine;
import org.imixs.workflow.engine.plugins.AbstractPlugin;
import org.imixs.workflow.exceptions.PluginException;

public class RulePlugin
extends AbstractPlugin {
    public static final String INVALID_SCRIPT = "INVALID_SCRIPT";
    public static final String VALIDATION_ERROR = "VALIDATION_ERROR";
    private static Logger logger = Logger.getLogger(RulePlugin.class.getName());

    public ItemCollection run(ItemCollection adocumentContext, ItemCollection adocumentActivity) throws PluginException {
        String script = adocumentActivity.getItemValueString("txtBusinessRule");
        if ("".equals(script.trim())) {
            return adocumentContext;
        }
        String sEngineType = adocumentActivity.getItemValueString("txtBusinessRuleEngine");
        RuleEngine ruleEngine = new RuleEngine(sEngineType);
        ItemCollection result = ruleEngine.evaluateBusinessRule(script, adocumentContext, adocumentActivity);
        if (result == null) {
            this.evaluateDeprecatedScript(ruleEngine, adocumentActivity);
        } else {
            Double d;
            Long followUpActivity;
            Boolean isValidActivity = true;
            if (result.hasItem("isValid")) {
                isValidActivity = result.getItemValueBoolean("isValid");
                result.removeItem("isValid");
            }
            if (isValidActivity != null && !isValidActivity.booleanValue()) {
                String sErrorCode = VALIDATION_ERROR;
                String oErrorCode = null;
                if (result.hasItem("errorCode")) {
                    oErrorCode = result.getItemValueString("errorCode");
                    result.removeItem("errorCode");
                }
                if (oErrorCode != null && oErrorCode instanceof String) {
                    sErrorCode = oErrorCode.toString();
                }
                Object[] params = null;
                if (result.hasItem("errorMessage")) {
                    params = result.getItemValue("errorMessage").toArray();
                    result.removeItem("errorMessage");
                }
                throw new PluginException(RulePlugin.class.getName(), sErrorCode, "BusinessRule: validation failed - ErrorCode=" + sErrorCode, params);
            }
            String followUp = null;
            if (result.hasItem("followUp")) {
                followUp = result.getItemValueString("followUp");
                result.removeItem("followUp");
            }
            if (followUp != null && (followUpActivity = Long.valueOf((d = Double.valueOf(followUp.toString())).longValue())) != null && followUpActivity > 0L) {
                adocumentActivity.replaceItemValue("keyFollowUp", (Object)"1");
                adocumentActivity.replaceItemValue("numNextActivityID", (Object)followUpActivity);
            }
            for (Map.Entry entry : result.getAllItems().entrySet()) {
                String itemName = (String)entry.getKey();
                if (itemName.startsWith("$")) continue;
                logger.finest("......Update item '" + itemName + "'");
                adocumentContext.replaceItemValue(itemName, entry.getValue());
            }
        }
        this.updateEvent(ruleEngine, adocumentActivity);
        return adocumentContext;
    }

    private void evaluateDeprecatedScript(RuleEngine ruleEngine, ItemCollection adocumentActivity) throws PluginException {
        Double d;
        Long followUpActivity;
        logger.warning("Script is deprecated - use JSON object 'result'");
        Boolean isValidActivity = true;
        isValidActivity = (Boolean)ruleEngine.getScriptEngine().get("isValid");
        if (isValidActivity != null && !isValidActivity.booleanValue()) {
            String sErrorCode = VALIDATION_ERROR;
            Object oErrorCode = null;
            oErrorCode = ruleEngine.getScriptEngine().get("errorCode");
            if (oErrorCode != null && oErrorCode instanceof String) {
                sErrorCode = oErrorCode.toString();
            }
            Object[] params = null;
            params = ruleEngine.evaluateNativeScriptArray("errorMessage");
            throw new PluginException(RulePlugin.class.getName(), sErrorCode, "BusinessRule: validation failed - ErrorCode=" + sErrorCode, params);
        }
        Object followUp = null;
        followUp = ruleEngine.getScriptEngine().get("followUp");
        if (followUp != null && (followUpActivity = Long.valueOf((d = Double.valueOf(followUp.toString())).longValue())) != null && followUpActivity > 0L) {
            adocumentActivity.replaceItemValue("keyFollowUp", (Object)"1");
            adocumentActivity.replaceItemValue("numNextActivityID", (Object)followUpActivity);
        }
    }

    private void updateEvent(RuleEngine ruleEngine, ItemCollection event) {
        ItemCollection newEvent = ruleEngine.convertScriptVariableToItemCollection("event");
        for (Map.Entry entry : newEvent.getAllItems().entrySet()) {
            String key = (String)entry.getKey();
            List newValue = (List)entry.getValue();
            logger.finest("......update event property " + (String)entry.getKey());
            event.replaceItemValue(key, (Object)newValue);
        }
    }
}

