/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.workflow.engine.scheduler;

import java.io.Serializable;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.faces.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.scheduler.SchedulerService;
import org.imixs.workflow.exceptions.AccessDeniedException;

@Named
@RequestScoped
public class SchedulerController
implements Serializable {
    private ItemCollection configuration = null;
    private String name;
    private String schedulerClass;
    @Inject
    private SchedulerService schedulerService;
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(SchedulerController.class.getName());

    @PostConstruct
    public void init() {
        this.configuration = this.schedulerService.loadConfiguration(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchedulerClass() {
        return this.schedulerClass;
    }

    public void setSchedulerClass(String schedulerClass) {
        this.schedulerClass = schedulerClass;
    }

    public ItemCollection getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new ItemCollection();
            this.configuration.setItemValue("$workflowsummary", (Object)this.getName());
            this.configuration.setItemValue("txtname", (Object)this.getName());
            this.configuration.setItemValue("_scheduler_class", (Object)this.getSchedulerClass());
        }
        return this.configuration;
    }

    public void setConfiguration(ItemCollection configuration) {
        this.configuration = configuration;
    }

    public void saveConfiguration() {
        this.configuration.setItemValue("_scheduler_class", (Object)this.getSchedulerClass());
        this.schedulerService.saveConfiguration(this.getConfiguration());
    }

    public void refresh() {
        this.configuration = this.schedulerService.loadConfiguration(this.getName());
    }

    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void startScheduler() throws AccessDeniedException, ParseException {
        this.configuration = this.schedulerService.start(this.getConfiguration());
        this.schedulerService.saveConfiguration(this.configuration);
    }

    public void stopScheduler() {
        this.configuration = this.schedulerService.stop(this.getConfiguration());
        this.schedulerService.saveConfiguration(this.configuration);
    }

    public void restartScheduler(ActionEvent event) throws Exception {
        this.stopScheduler();
        this.startScheduler();
    }

    public String millisToShortDHMS(int duration) {
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.finest("......confert ms " + duration);
        }
        String res = "";
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        res = days == 0L ? String.format("%d hours, %d minutes, %d seconds", hours, minutes, seconds) : String.format("%d days, %d hours, %d minutes, %d seconds", days, hours, minutes, seconds);
        return res;
    }
}

