/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public final class ClassWhiteList {
    private static final Log log;
    private static final String CLASSES_PROPERTY_NAME = "infinispan.deserialization.whitelist.classes";
    private static final String REGEXPS_PROPERTY_NAME = "infinispan.deserialization.whitelist.regexps";
    private static final Set<String> SYS_ALLOWED_CLASSES;
    private static final List<String> SYS_ALLOWED_REGEXP;
    private final Set<String> classes = new CopyOnWriteArraySet<String>(SYS_ALLOWED_CLASSES);
    private final List<String> regexps = new CopyOnWriteArrayList<String>(SYS_ALLOWED_REGEXP);
    private final List<Pattern> compiled = new CopyOnWriteArrayList<Pattern>();

    public ClassWhiteList() {
        this(Collections.emptySet(), Collections.emptyList());
    }

    public ClassWhiteList(List<String> regexps) {
        this(Collections.emptySet(), regexps);
    }

    private ClassWhiteList(Collection<String> classes, List<String> regexps) {
        Collection<String> classList = Objects.requireNonNull(classes, "Classes must not be null");
        Collection regexList = Objects.requireNonNull(regexps, "Regexps must not be null");
        this.classes.addAll(classList);
        this.regexps.addAll(regexList);
        this.compiled.addAll(this.regexps.stream().map(Pattern::compile).collect(Collectors.toList()));
    }

    public boolean isSafeClass(String className) {
        boolean isClassAllowed = this.classes.contains(className);
        if (isClassAllowed) {
            return true;
        }
        boolean regexMatch = this.compiled.stream().anyMatch(p -> p.matcher(className).find());
        if (regexMatch) {
            return true;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Class '%s' not in whitelist", className);
        }
        return false;
    }

    public void addClasses(Class<?> ... classes) {
        Arrays.stream(classes).forEach(c -> this.classes.add(c.getName()));
    }

    public void addRegexps(String ... regexps) {
        this.regexps.addAll(Arrays.asList(regexps));
        this.compiled.addAll(Arrays.stream(regexps).map(Pattern::compile).collect(Collectors.toList()));
    }

    static {
        String cls;
        log = LogFactory.getLog(ClassWhiteList.class);
        SYS_ALLOWED_CLASSES = new HashSet<String>();
        SYS_ALLOWED_REGEXP = new ArrayList<String>();
        SYS_ALLOWED_CLASSES.add(Byte.class.getName());
        SYS_ALLOWED_CLASSES.add(Short.class.getName());
        SYS_ALLOWED_CLASSES.add(Integer.class.getName());
        SYS_ALLOWED_CLASSES.add(Long.class.getName());
        SYS_ALLOWED_CLASSES.add(Float.class.getName());
        SYS_ALLOWED_CLASSES.add(Double.class.getName());
        SYS_ALLOWED_CLASSES.add(Character.class.getName());
        SYS_ALLOWED_CLASSES.add(String.class.getName());
        SYS_ALLOWED_CLASSES.add(HashSet.class.getName());
        SYS_ALLOWED_CLASSES.add(HashMap.class.getName());
        SYS_ALLOWED_CLASSES.add(Date.class.getName());
        SYS_ALLOWED_CLASSES.add("org.infinispan.commons.marshall.jboss.JBossExternalizerAdapter");
        String regexps = System.getProperty(REGEXPS_PROPERTY_NAME);
        if (regexps != null) {
            SYS_ALLOWED_REGEXP.addAll(Arrays.asList(regexps.trim().split(",")));
        }
        if ((cls = System.getProperty(CLASSES_PROPERTY_NAME)) != null) {
            SYS_ALLOWED_CLASSES.addAll(Arrays.asList(cls.trim().split(",")));
        }
    }
}

