/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.io;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.configuration.io.NamingStrategy;

public abstract class AbstractConfigurationWriter
implements ConfigurationWriter {
    protected final Writer writer;
    protected final Deque<Tag> tagStack = new ArrayDeque<Tag>();
    protected final Map<String, String> namespaces = new HashMap<String, String>();
    protected int currentIndent = 0;
    private final int indent;
    private final boolean prettyPrint;
    protected final NamingStrategy naming;

    protected AbstractConfigurationWriter(Writer writer, int indent, boolean prettyPrint, NamingStrategy naming) {
        this.writer = writer;
        this.indent = indent;
        this.prettyPrint = prettyPrint;
        this.naming = naming;
    }

    @Override
    public void writeStartElement(Enum<?> name) {
        this.writeStartElement(name.toString());
    }

    @Override
    public void writeStartElement(String prefix, String namespace, Enum<?> name) {
        this.writeStartElement(prefix, namespace, name.toString());
    }

    @Override
    public void writeStartListElement(Enum<?> name, boolean explicit) {
        this.writeStartListElement(name.toString(), explicit);
    }

    @Override
    public void writeStartListElement(String prefix, String namespace, Enum<?> name, boolean explicit) {
        this.writeStartListElement(prefix, namespace, name.toString(), explicit);
    }

    @Override
    public void writeEndListElement() {
        this.writeEndElement();
    }

    @Override
    public void writeStartMapElement(Enum<?> name) {
        this.writeStartMapElement(name.toString());
    }

    @Override
    public void writeStartMapEntry(Enum<?> name, Enum<?> key, String value) {
        this.writeStartMapEntry(name.toString(), key.toString(), value);
    }

    @Override
    public void writeAttribute(Enum<?> name, String value) {
        this.writeAttribute(name.toString(), value);
    }

    @Override
    public void writeEmptyElement(Enum<?> name) {
        this.writeEmptyElement(name.toString());
    }

    protected void nl() throws IOException {
        if (this.prettyPrint) {
            this.writer.write(System.lineSeparator());
        }
    }

    protected void writeIndent() throws IOException {
        if (this.prettyPrint) {
            for (int i = 0; i < this.currentIndent; ++i) {
                this.writer.write(32);
            }
        }
    }

    protected void indent() {
        this.currentIndent += this.indent;
    }

    protected void outdent() {
        this.currentIndent -= this.indent;
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }

    public static class Tag {
        final String name;
        final boolean repeating;
        final boolean explicit;

        public Tag(String name, boolean repeating, boolean explicit) {
            this.name = name;
            this.repeating = repeating;
            this.explicit = explicit;
        }

        public Tag(String name) {
            this(name, false, false);
        }

        public String getName() {
            return this.name;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        public String toString() {
            return this.name + (this.repeating ? "+" : "");
        }
    }
}

