/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Util;

public final class BinaryTranscoder
extends OneToManyTranscoder {
    private final AtomicReference<Marshaller> marshallerRef;

    public BinaryTranscoder(Marshaller marshaller) {
        super(MediaType.APPLICATION_UNKNOWN, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_WWW_FORM_URLENCODED, MediaType.TEXT_PLAIN);
        this.marshallerRef = new AtomicReference<Marshaller>(marshaller);
    }

    public void overrideMarshaller(Marshaller marshaller) {
        this.marshallerRef.set(marshaller);
    }

    private Marshaller getMashaller() {
        return this.marshallerRef.get();
    }

    @Override
    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.equals(MediaType.APPLICATION_UNKNOWN)) {
                if (contentType.match(MediaType.APPLICATION_UNKNOWN)) {
                    return content;
                }
                return this.convertToByteArray(content, contentType);
            }
            if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                return StandardConversions.decodeOctetStream(content, contentType);
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                if (content instanceof byte[]) {
                    return this.getMashaller().objectFromByteBuffer((byte[])content);
                }
                if (content instanceof WrappedByteArray) {
                    return this.getMashaller().objectFromByteBuffer(((WrappedByteArray)content).getBytes());
                }
                return content;
            }
            if (destinationType.match(MediaType.TEXT_PLAIN)) {
                return StandardConversions.convertTextToOctetStream(content, contentType);
            }
            if (destinationType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
                return this.convertToUrlEncoded(content, contentType);
            }
            throw Log.CONTAINER.unsupportedConversion(Util.toStr(content), contentType, destinationType);
        }
        catch (IOException | ClassNotFoundException | EncodingException e) {
            throw Log.CONTAINER.errorTranscoding(Util.toStr(content), contentType, destinationType, e);
        }
    }

    private Object convertToByteArray(Object content, MediaType contentType) {
        try {
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                return StandardConversions.decodeOctetStream(content, contentType);
            }
            if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
                return StandardConversions.convertUrlEncodedToOctetStream(content);
            }
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                return StandardConversions.convertTextToOctetStream(content, contentType);
            }
            return this.getMashaller().objectToByteBuffer(StandardConversions.decodeObjectContent(content, contentType));
        }
        catch (IOException | InterruptedException | EncodingException e) {
            throw Log.CONTAINER.errorTranscoding(Util.toStr(content), contentType, MediaType.APPLICATION_UNKNOWN, e);
        }
    }

    private Object convertToUrlEncoded(Object content, MediaType contentType) {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            return StandardConversions.convertOctetStreamToUrlEncoded(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.convertUrlEncodedToObject(content);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToUrlEncoded(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return content;
        }
        throw Log.CONTAINER.unsupportedConversion(Util.toStr(content), MediaType.APPLICATION_UNKNOWN, contentType);
    }
}

