/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.configuration.attributes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.attributes.Updatable;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.logging.Log;

public final class Attribute<T>
implements Cloneable,
Matchable<Attribute<?>>,
Updatable<Attribute<T>> {
    private final AttributeDefinition<T> definition;
    private T value;
    private boolean protect;
    private boolean modified;
    private List<AttributeListener<T>> listeners;

    Attribute(AttributeDefinition<T> definition) {
        this.definition = definition;
        this.value = definition.getDefaultValue();
    }

    public String name() {
        return this.definition.name();
    }

    public T get() {
        return this.value;
    }

    public T orElse(T other) {
        return this.modified ? this.value : other;
    }

    public T getInitialValue() {
        return this.definition.getDefaultValue();
    }

    public void validate() {
        this.definition.validate(this.value);
    }

    public Attribute<T> protect() {
        if (!this.protect && this.definition.isImmutable()) {
            this.protect = true;
        }
        return this;
    }

    public void set(T value) {
        if (this.protect) {
            throw Log.CONFIG.protectedAttribute(this.definition.name());
        }
        T oldValue = this.value;
        this.value = value;
        this.modified = true;
        this.fireValueChanged(oldValue);
    }

    public void setImplied(T value) {
        if (this.protect) {
            throw Log.CONFIG.protectedAttribute(this.definition.name());
        }
        T oldValue = this.value;
        this.value = value;
        this.modified = false;
        this.fireValueChanged(oldValue);
    }

    public void fromString(String value) {
        this.set(this.definition.parse(value));
    }

    public T computeIfAbsent(Supplier<T> supplier) {
        if (this.value == null) {
            this.set(supplier.get());
        }
        return this.value;
    }

    public boolean isImmutable() {
        return this.definition.isImmutable();
    }

    public boolean isPersistent() {
        return this.definition.isAutoPersist();
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isRepeated() {
        return this.definition.isRepeated();
    }

    public void addListener(AttributeListener<T> listener) {
        if (this.isImmutable() && this.isProtect()) {
            throw new UnsupportedOperationException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<AttributeListener<T>>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(AttributeListener<T> listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public boolean isNull() {
        return this.value == null;
    }

    boolean isProtect() {
        return this.protect;
    }

    public AttributeDefinition<T> getAttributeDefinition() {
        return this.definition;
    }

    private void fireValueChanged(T oldValue) {
        if (this.listeners != null) {
            for (AttributeListener<T> listener : this.listeners) {
                listener.attributeChanged(this, oldValue);
            }
        }
    }

    protected Attribute<T> clone() {
        try {
            Attribute clone = (Attribute)super.clone();
            clone.modified = this.modified;
            clone.listeners = null;
            clone.protect = false;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException(e);
        }
    }

    public void read(Attribute<T> other) {
        AttributeCopier<T> copier = this.definition.copier();
        if (copier == null) {
            Object clone = other.clone();
            this.value = ((Attribute)clone).value;
        } else {
            this.value = copier.copyAttribute(other.value);
        }
        this.modified = other.modified;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.modified ? 1231 : 1237);
        result = 31 * result + (this.value == null ? 0 : (this.value.getClass().isArray() ? Arrays.deepHashCode((Object[])this.value) : this.value.hashCode()));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        return Objects.deepEquals(this.value, other.value);
    }

    @Override
    public boolean matches(Attribute<?> other) {
        if (other == null) {
            return false;
        }
        if (!this.definition.equals(other.definition)) {
            return false;
        }
        if (this.definition.isGlobal()) {
            if (Matchable.class.isAssignableFrom(this.definition.getType())) {
                return ((Matchable)this.value).matches(other.value);
            }
            return Objects.equals(this.value, other.value);
        }
        return true;
    }

    @Override
    public void update(String elementName, Attribute<T> other) {
        if (this.definition.equals(other.definition)) {
            if (this.isImmutable()) {
                if (this.definition.isGlobal() && !this.equals(other)) {
                    throw Log.CONFIG.incompatibleAttribute(this.definition.name(), elementName, String.valueOf(this.value), String.valueOf(other.value));
                }
            } else if (!this.equals(other)) {
                if (other.isModified()) {
                    this.set(other.get());
                } else {
                    this.setImplied(other.get());
                }
                Log.CONFIG.debugf("Updated attribute '%s' to value '%s'", this.name(), this.value);
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(this) + "!=" + String.valueOf(other));
        }
    }

    @Override
    public void validateUpdate(String parentName, Attribute<T> other) {
        if (this.definition.equals(other.definition)) {
            if (this.isImmutable() && this.definition.isGlobal() && !Objects.equals(this.value, other.value)) {
                throw Log.CONFIG.incompatibleAttribute(parentName, this.definition.name(), String.valueOf(this.value), String.valueOf(other.value));
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(this) + "!=" + String.valueOf(other));
        }
    }

    public void apply(Consumer<T> consumer) {
        if (this.isModified()) {
            consumer.accept(this.value);
        }
    }

    public String toString() {
        return this.definition.name() + "=" + String.valueOf(this.value);
    }

    public void reset() {
        if (this.protect) {
            throw new IllegalStateException("Cannot reset a protected Attribute");
        }
        this.value = this.definition.getDefaultValue();
        this.modified = false;
    }

    void write(ConfigurationWriter writer, String name) {
        if (this.modified && this.value != null) {
            this.definition.serializer().serialize(writer, name, this.value);
        }
    }
}

