/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface IntSet
extends Set<Integer> {
    @Override
    public boolean add(int var1);

    public void set(int var1);

    public boolean remove(int var1);

    public boolean contains(int var1);

    public boolean addAll(IntSet var1);

    public boolean containsAll(IntSet var1);

    public boolean removeAll(IntSet var1);

    public boolean retainAll(IntSet var1);

    public PrimitiveIterator.OfInt iterator();

    public IntStream intStream();

    @Override
    default public Stream<Integer> stream() {
        return Set.super.stream();
    }

    default public void forEach(IntConsumer action) {
        Objects.requireNonNull(action);
        PrimitiveIterator.OfInt iterator = this.iterator();
        while (iterator.hasNext()) {
            action.accept(iterator.nextInt());
        }
    }

    default public Spliterator.OfInt intSpliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1);
    }

    default public boolean removeIf(IntPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        PrimitiveIterator.OfInt iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!filter.test(iterator.nextInt())) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    default public int[] toIntArray() {
        int[] array = new int[this.size()];
        PrimitiveIterator.OfInt iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
        }
        return array;
    }

    public byte[] toBitSet();

    public int nextSetBit(int var1);
}

