/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;

public class ReflectionUtil {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Class<?>[] primitives = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
    private static final Class<?>[] primitiveArrays = new Class[]{int[].class, byte[].class, short[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class};
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    public static List<Method> getAllMethods(Class<?> c, Class<? extends Annotation> annotationType) {
        ArrayList<Method> annotated = new ArrayList<Method>();
        ReflectionUtil.inspectRecursively(c, annotated, annotationType);
        return annotated;
    }

    private static void getAnnotatedFieldHelper(List<Field> list, Class<?> c, Class<? extends Annotation> annotationType) {
        Field[] declaredFields;
        for (Field field : declaredFields = c.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationType)) continue;
            list.add(field);
        }
    }

    public static Method findMethod(Class<?> type, String methodName) {
        try {
            return type.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            if (type.equals(Object.class) || type.isInterface()) {
                throw new CacheException(e);
            }
            return ReflectionUtil.findMethod(type.getSuperclass(), methodName);
        }
    }

    public static Method findMethod(Class<?> type, String methodName, Class<?> ... parameters) {
        try {
            return type.getDeclaredMethod(methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            if (type.equals(Object.class) || type.isInterface()) {
                throw new CacheException(e);
            }
            return ReflectionUtil.findMethod(type.getSuperclass(), methodName, parameters);
        }
    }

    private static void inspectRecursively(Class<?> c, List<Method> s, Class<? extends Annotation> annotationType) {
        for (Method method : c.getDeclaredMethods()) {
            if (!ReflectionUtil.notFound(method, s) || !method.isAnnotationPresent(annotationType)) continue;
            s.add(method);
        }
        if (!c.equals(Object.class)) {
            if (!c.isInterface()) {
                ReflectionUtil.inspectRecursively(c.getSuperclass(), s, annotationType);
            }
            for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                ReflectionUtil.inspectRecursively(genericDeclaration, s, annotationType);
            }
        }
    }

    private static void inspectFieldsRecursively(Class<?> c, List<Field> s, Class<? extends Annotation> annotationType) {
        if (c == null || c.isInterface()) {
            return;
        }
        for (Field f : c.getDeclaredFields()) {
            if (!f.isAnnotationPresent(annotationType)) continue;
            s.add(f);
        }
        if (!c.equals(Object.class)) {
            ReflectionUtil.inspectFieldsRecursively(c.getSuperclass(), s, annotationType);
        }
    }

    private static boolean notFound(Method m, Collection<Method> s) {
        for (Method found : s) {
            if (!m.getName().equals(found.getName()) || !Arrays.equals(m.getParameterTypes(), found.getParameterTypes())) continue;
            return false;
        }
        return true;
    }

    private static Field findFieldRecursively(Class<?> c, String fieldName) {
        Field f;
        block2: {
            f = null;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (c.equals(Object.class)) break block2;
                f = ReflectionUtil.findFieldRecursively(c.getSuperclass(), fieldName);
            }
        }
        return f;
    }

    public static Object invokeAccessibly(Object instance, Method method, Object ... parameters) {
        method.setAccessible(true);
        return ReflectionUtil.invokeMethod(instance, method, parameters);
    }

    public static Object invokeMethod(Object instance, Method method, Object[] parameters) {
        try {
            return method.invoke(instance, parameters);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new CacheException("Unable to invoke method " + String.valueOf(method) + " on object of type " + (instance == null ? "null" : instance.getClass().getSimpleName()) + (String)(parameters != null ? " with parameters " + String.valueOf(Arrays.asList(parameters)) : ""), cause);
        }
        catch (Exception e) {
            throw new CacheException("Unable to invoke method " + String.valueOf(method) + " on object of type " + (instance == null ? "null" : instance.getClass().getSimpleName()) + (String)(parameters != null ? " with parameters " + String.valueOf(Arrays.asList(parameters)) : ""), e);
        }
    }

    public static void setAccessible(Method m) {
        try {
            m.setAccessible(true);
        }
        catch (Exception e) {
            throw new CacheException("Unable to change method accessibility " + String.valueOf(m), e);
        }
    }

    public static void setAccessibly(Object instance, Field field, Object value) {
        field.setAccessible(true);
        ReflectionUtil.setField(instance, field, value);
    }

    public static void setField(Object instance, Field field, Object value) {
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new CacheException("Unable to set field " + field.getName() + " on object of type " + (instance == null ? "null" : instance.getClass().getName()) + " to " + String.valueOf(value), e);
        }
    }

    public static Method findGetterForField(Class<?> c, String fieldName) {
        Method retval = ReflectionUtil.findGetterForFieldUsingReflection(c, fieldName);
        if (retval == null && !c.equals(Object.class) && !c.isInterface() && (retval = ReflectionUtil.findGetterForField(c.getSuperclass(), fieldName)) == null) {
            Class<?> ifc;
            Class<?>[] classArray = c.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (retval = ReflectionUtil.findGetterForField(ifc = classArray[i], fieldName)) == null; ++i) {
            }
        }
        return retval;
    }

    private static Method findGetterForFieldUsingReflection(Class<?> c, String fieldName) {
        for (Method m : c.getDeclaredMethods()) {
            String name = m.getName();
            String s = null;
            if (name.startsWith("get")) {
                s = name.substring(3);
            } else if (name.startsWith("is")) {
                s = name.substring(2);
            }
            if (s == null || !s.equalsIgnoreCase(fieldName)) continue;
            return m;
        }
        return null;
    }

    public static Method findSetterForField(Class<?> c, String fieldName) {
        if (c == Object.class) {
            return null;
        }
        for (Method m : c.getDeclaredMethods()) {
            String name = m.getName();
            String s = null;
            if (name.startsWith("set")) {
                s = name.substring(3);
            }
            if (s == null || !s.equalsIgnoreCase(fieldName)) continue;
            return m;
        }
        return ReflectionUtil.findSetterForField(c.getSuperclass(), fieldName);
    }

    public static String extractFieldName(String setterOrGetter) {
        String field = null;
        if (setterOrGetter.startsWith("set") || setterOrGetter.startsWith("get")) {
            field = setterOrGetter.substring(3);
        } else if (setterOrGetter.startsWith("is")) {
            field = setterOrGetter.substring(2);
        }
        if (field != null && field.length() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(Character.toLowerCase(field.charAt(0)));
            if (field.length() > 2) {
                sb.append(field.substring(1));
            }
            return sb.toString();
        }
        return null;
    }

    public static Object getValue(Object instance, String fieldName) {
        Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
        if (f == null) {
            throw new CacheException("Could not find field named '" + fieldName + "' on instance " + String.valueOf(instance));
        }
        try {
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (IllegalAccessException iae) {
            throw new CacheException("Cannot access field " + String.valueOf(f), iae);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> ann) {
        T a;
        while ((a = clazz.getAnnotation(ann)) == null) {
            Class<?> superclass;
            if (!clazz.isInterface()) {
                Class<?>[] interfaces;
                for (Class<?> inter : interfaces = clazz.getInterfaces()) {
                    a = ReflectionUtil.getAnnotation(inter, ann);
                    if (a == null) continue;
                    return a;
                }
            }
            if ((superclass = clazz.getSuperclass()) == null) {
                return null;
            }
            clazz = superclass;
        }
        return a;
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        return ReflectionUtil.getAnnotation(clazz, annotation) != null;
    }

    public static Class<?>[] toClassArray(String[] typeList, ClassLoader classLoader) throws ClassNotFoundException {
        if (typeList == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] retval = new Class[typeList.length];
        int i = 0;
        for (String s : typeList) {
            retval[i++] = ReflectionUtil.getClassForName(s, classLoader);
        }
        return retval;
    }

    public static Class<?> getClassForName(String name, ClassLoader cl) throws ClassNotFoundException {
        try {
            return Util.loadClassStrict(name, cl);
        }
        catch (ClassNotFoundException cnfe) {
            for (Class<?> primitive : primitives) {
                if (!name.equals(primitive.getName())) continue;
                return primitive;
            }
            for (Class<?> primitive : primitiveArrays) {
                if (!name.equals(primitive.getName())) continue;
                return primitive;
            }
            throw new ClassNotFoundException("Class " + name + " cannot be found");
        }
    }

    public static String[] toStringArray(Class<?>[] classes) {
        if (classes == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = classes[i].getName();
        }
        return classNames;
    }

    public static Field getField(String fieldName, Class<?> objectClass) {
        try {
            return objectClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (!objectClass.equals(Object.class)) {
                return ReflectionUtil.getField(fieldName, objectClass.getSuperclass());
            }
            return null;
        }
    }

    public static <T> T unwrap(Object obj, Class<T> clazz) {
        if (clazz != null && clazz.isAssignableFrom(obj.getClass())) {
            return clazz.cast(obj);
        }
        throw Log.CONTAINER.unableToUnwrap(obj, clazz);
    }

    public static <T> T unwrapAny(Class<T> clazz, Object ... objs) {
        if (clazz != null) {
            for (Object o : objs) {
                if (!clazz.isAssignableFrom(o.getClass())) continue;
                return clazz.cast(o);
            }
        }
        throw Log.CONTAINER.unableToUnwrapAny(Arrays.toString(objs), clazz);
    }

    public static int getIntAccessibly(Field f, Object instance) {
        try {
            f.setAccessible(true);
            return f.getInt(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

