/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.BufferSizePredictor;
import org.infinispan.marshall.BufferSizePredictorFactory;
import org.infinispan.marshall.Marshaller;

public abstract class AbstractMarshaller
implements Marshaller {
    protected static final int DEFAULT_BUF_SIZE = 512;

    protected abstract ByteBuffer objectToBuffer(Object var1, int var2) throws IOException, InterruptedException;

    public ByteBuffer objectToBuffer(Object obj) throws IOException, InterruptedException {
        ByteBuffer byteBuffer;
        int length;
        BufferSizePredictor sizePredictor = BufferSizePredictorFactory.getBufferSizePredictor();
        int estimatedSize = sizePredictor.nextSize(obj);
        if (estimatedSize > (length = (byteBuffer = this.objectToBuffer(obj, estimatedSize)).getLength()) * 4) {
            byte[] buffer = this.trimBuffer(byteBuffer);
            byteBuffer = new ByteBuffer(buffer, 0, buffer.length);
        }
        sizePredictor.recordSize(length);
        return byteBuffer;
    }

    public byte[] objectToByteBuffer(Object o) throws IOException, InterruptedException {
        BufferSizePredictor sizePredictor = BufferSizePredictorFactory.getBufferSizePredictor();
        byte[] bytes = this.objectToByteBuffer(o, sizePredictor.nextSize(o));
        sizePredictor.recordSize(bytes.length);
        return bytes;
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        ByteBuffer b = this.objectToBuffer(obj, estimatedSize);
        return this.trimBuffer(b);
    }

    private byte[] trimBuffer(ByteBuffer b) {
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    public Object objectFromInputStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        int bytesRead;
        byte[] buf;
        ExposedByteArrayOutputStream bytes;
        int len = inputStream.available();
        if (len > 0) {
            bytes = new ExposedByteArrayOutputStream(len);
            buf = new byte[Math.min(len, 1024)];
        } else {
            bytes = new ExposedByteArrayOutputStream();
            buf = new byte[1024];
        }
        while ((bytesRead = inputStream.read(buf, 0, buf.length)) != -1) {
            bytes.write(buf, 0, bytesRead);
        }
        return this.objectFromByteBuffer(bytes.getRawBuffer(), 0, bytes.size());
    }
}

