/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;

public final class DefaultTranscoder
implements Transcoder {
    private static final Log log = LogFactory.getLog(DefaultTranscoder.class);
    private static final Set<MediaType> supportedTypes = new HashSet<MediaType>();
    private final GenericJBossMarshaller jbossMarshaller;
    private final JavaSerializationMarshaller javaMarshaller;

    public DefaultTranscoder(GenericJBossMarshaller marshaller, JavaSerializationMarshaller javaMarshaller) {
        this.javaMarshaller = javaMarshaller;
        this.jbossMarshaller = marshaller;
    }

    public DefaultTranscoder() {
        this.javaMarshaller = new JavaSerializationMarshaller();
        this.jbossMarshaller = new GenericJBossMarshaller();
    }

    @Override
    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.equals(MediaType.APPLICATION_UNKNOWN)) {
                return this.convertToByteArray(content, contentType);
            }
            if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                return this.convertToOctetStream(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return this.convertToObject(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.TEXT_PLAIN)) {
                return this.convertToTextPlain(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
                return this.convertToUrlEncoded(content, contentType);
            }
            throw log.unsupportedContent(content);
        }
        catch (IOException | InterruptedException | EncodingException e) {
            throw log.unsupportedContent(content);
        }
    }

    private Object convertToByteArray(Object content, MediaType contentType) {
        try {
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                return StandardConversions.decodeOctetStream(content, contentType);
            }
            if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
                return StandardConversions.convertUrlEncodedToOctetStream(content);
            }
            if (contentType.match(MediaType.TEXT_PLAIN)) {
                return StandardConversions.convertTextToOctetStream(content, contentType);
            }
            return StandardConversions.convertJavaToOctetStream(content, contentType, this.jbossMarshaller);
        }
        catch (IOException | InterruptedException | EncodingException e) {
            throw log.unsupportedContent(content);
        }
    }

    private Object convertToUrlEncoded(Object content, MediaType contentType) {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            return StandardConversions.convertOctetStreamToUrlEncoded(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.convertUrlEncodedToObject(content);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToUrlEncoded(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return content;
        }
        throw log.unsupportedContent(content);
    }

    private Object convertToTextPlain(Object content, MediaType contentType, MediaType destinationType) {
        if (contentType.match(MediaType.APPLICATION_UNKNOWN)) {
            try {
                return StandardConversions.convertJavaToOctetStream(content, MediaType.APPLICATION_OBJECT, this.javaMarshaller);
            }
            catch (IOException | InterruptedException e) {
                throw log.unsupportedContent(content);
            }
        }
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            byte[] decoded = StandardConversions.decodeOctetStream(content, destinationType);
            return StandardConversions.convertOctetStreamToText(decoded, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.convertJavaToText(content, contentType, destinationType);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToText(content, contentType, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return StandardConversions.convertUrlEncodedToText(content, destinationType);
        }
        throw log.unsupportedContent(content);
    }

    private Object convertToObject(Object content, MediaType contentType, MediaType destinationType) {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            byte[] decoded = StandardConversions.decodeOctetStream(content, destinationType);
            return StandardConversions.convertOctetStreamToJava(decoded, destinationType, this.javaMarshaller);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.decodeObjectContent(content, contentType);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToObject(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return StandardConversions.convertUrlEncodedToObject(content);
        }
        if (contentType.equals(MediaType.APPLICATION_UNKNOWN)) {
            if (content instanceof byte[]) {
                return this.tryDeserialize((byte[])content);
            }
            if (content instanceof WrappedByteArray) {
                return this.tryDeserialize(((WrappedByteArray)content).getBytes());
            }
            return content;
        }
        throw log.unsupportedContent(content);
    }

    private Object tryDeserialize(byte[] content) {
        try {
            return this.jbossMarshaller.objectFromByteBuffer(content);
        }
        catch (IOException | ClassNotFoundException e1) {
            try {
                return this.javaMarshaller.objectFromByteBuffer(content);
            }
            catch (IOException | ClassNotFoundException e) {
                return new String(content, StandardCharsets.UTF_8);
            }
        }
    }

    public Object convertToOctetStream(Object content, MediaType contentType, MediaType destinationType) throws IOException, InterruptedException {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM) || contentType.match(MediaType.APPLICATION_UNKNOWN)) {
            return StandardConversions.decodeOctetStream(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.convertJavaToOctetStream(content, contentType, this.javaMarshaller);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToOctetStream(content, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return StandardConversions.convertUrlEncodedToOctetStream(content);
        }
        throw log.unsupportedContent(content);
    }

    @Override
    public Set<MediaType> getSupportedMediaTypes() {
        return supportedTypes;
    }

    private boolean in(MediaType mediaType, Set<MediaType> set) {
        return set.stream().anyMatch(s -> s.match(mediaType));
    }

    @Override
    public boolean supportsConversion(MediaType mediaType, MediaType other) {
        return this.in(mediaType, supportedTypes) && this.in(other, supportedTypes);
    }

    static {
        supportedTypes.add(MediaType.APPLICATION_OBJECT);
        supportedTypes.add(MediaType.APPLICATION_OCTET_STREAM);
        supportedTypes.add(MediaType.APPLICATION_WWW_FORM_URLENCODED);
        supportedTypes.add(MediaType.TEXT_PLAIN);
        supportedTypes.add(MediaType.APPLICATION_UNKNOWN);
    }
}

