/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ClassAttributeSerializer;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.global.PrincipalRoleMapperConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.audit.NullAuditLogger;
import org.infinispan.security.impl.CacheRoleImpl;

public class GlobalAuthorizationConfiguration
implements ConfigurationInfo {
    private static final Map<String, Role> DEFAULT_ROLES;
    public static final AttributeDefinition<Boolean> ENABLED;
    public static final AttributeDefinition<Long> CACHE_SIZE;
    public static final AttributeDefinition<AuditLogger> AUDIT_LOGGER;
    public static final AttributeDefinition<Map<String, Role>> ROLES;
    private final Attribute<Long> cacheSize;
    private static ElementDefinition ELEMENT_DEFINITION;
    private final Attribute<Boolean> enabled;
    private final Attribute<AuditLogger> auditLogger;
    private final Attribute<Map<String, Role>> roles;
    private final PrincipalRoleMapperConfiguration roleMapperConfiguration;
    private final AttributeSet attributes;
    private final List<ConfigurationInfo> subElements;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalAuthorizationConfiguration.class, new AttributeDefinition[]{ENABLED, CACHE_SIZE, AUDIT_LOGGER, ROLES});
    }

    public GlobalAuthorizationConfiguration(AttributeSet attributes, PrincipalRoleMapperConfiguration roleMapperConfiguration) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.cacheSize = attributes.attribute(CACHE_SIZE);
        this.auditLogger = attributes.attribute(AUDIT_LOGGER);
        this.roles = attributes.attribute(ROLES);
        this.roleMapperConfiguration = roleMapperConfiguration;
        this.subElements = Collections.singletonList(roleMapperConfiguration);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public long cacheSize() {
        return (Long)this.cacheSize.get();
    }

    public AuditLogger auditLogger() {
        return (AuditLogger)this.auditLogger.get();
    }

    public PrincipalRoleMapper principalRoleMapper() {
        return this.roleMapperConfiguration.roleMapper();
    }

    public PrincipalRoleMapperConfiguration roleMapperConfiguration() {
        return this.roleMapperConfiguration;
    }

    public Map<String, Role> roles() {
        return (Map)this.roles.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalAuthorizationConfiguration{roleMapperConfiguration=" + this.roleMapperConfiguration + ", attributes=" + this.attributes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalAuthorizationConfiguration that = (GlobalAuthorizationConfiguration)o;
        if (this.roleMapperConfiguration != null ? !this.roleMapperConfiguration.equals(that.roleMapperConfiguration) : that.roleMapperConfiguration != null) {
            return false;
        }
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        int result = this.roleMapperConfiguration != null ? this.roleMapperConfiguration.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }

    static {
        ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
        CACHE_SIZE = AttributeDefinition.builder((String)"cacheSize", (Object)1000L).immutable().build();
        AUDIT_LOGGER = AttributeDefinition.builder((String)"auditLogger", (Object)new NullAuditLogger()).copier(IdentityAttributeCopier.INSTANCE).serializer(ClassAttributeSerializer.INSTANCE).immutable().build();
        ROLES = AttributeDefinition.builder((String)"roles", new HashMap()).serializer((AttributeSerializer)new AttributeSerializer<Map<String, Role>, GlobalAuthorizationConfiguration, ConfigurationBuilderInfo>(){

            public Object getSerializationValue(Attribute<Map<String, Role>> attribute, GlobalAuthorizationConfiguration configurationElement) {
                if (!configurationElement.enabled()) {
                    return null;
                }
                return ((Map)attribute.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Role)e.getValue()).getPermissions()));
            }
        }).initializer((AttributeInitializer)new AttributeInitializer<Map<String, Role>>(){

            public Map<String, Role> initialize() {
                return DEFAULT_ROLES;
            }
        }).build();
        HashMap<String, CacheRoleImpl> roles = new HashMap<String, CacheRoleImpl>();
        roles.put("admin", new CacheRoleImpl("admin", true, AuthorizationPermission.ALL));
        roles.put("application", new CacheRoleImpl("application", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC));
        roles.put("deployer", new CacheRoleImpl("deployer", true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC, AuthorizationPermission.CREATE));
        roles.put("observer", new CacheRoleImpl("observer", true, AuthorizationPermission.ALL_READ));
        roles.put("___schema_manager", new CacheRoleImpl("___schema_manager", false, AuthorizationPermission.CREATE));
        roles.put("___script_manager", new CacheRoleImpl("___script_manager", false, AuthorizationPermission.CREATE));
        DEFAULT_ROLES = Collections.unmodifiableMap(roles);
        ELEMENT_DEFINITION = new DefaultElementDefinition(Element.AUTHORIZATION.getLocalName());
    }
}

