/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import org.infinispan.security.CachePermission;

public enum AuthorizationPermission {
    LIFECYCLE(1),
    READ(2),
    WRITE(4),
    EXEC(8),
    LISTEN(16),
    BULK_READ(32),
    BULK_WRITE(64),
    ADMIN(128),
    CREATE(256),
    ALL(Integer.MAX_VALUE),
    ALL_READ(READ.getMask() + BULK_READ.getMask()),
    ALL_WRITE(WRITE.getMask() + BULK_WRITE.getMask()),
    NONE(0);

    private final int mask;
    private final CachePermission securityPermission;

    private AuthorizationPermission(int mask) {
        this.mask = mask;
        this.securityPermission = new CachePermission(this);
    }

    public int getMask() {
        return this.mask;
    }

    public CachePermission getSecurityPermission() {
        return this.securityPermission;
    }

    public boolean matches(int mask) {
        return (this.mask & mask) == this.mask;
    }

    public boolean implies(AuthorizationPermission that) {
        return (this.mask & that.mask) == that.mask;
    }
}

