/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class IracTombstoneCleanupCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 37;
    private final ByteString cacheName;
    private IracTombstoneInfo tombstone;

    public IracTombstoneCleanupCommand() {
        this(null);
    }

    public IracTombstoneCleanupCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracTombstoneCleanupCommand(ByteString cacheName, IracTombstoneInfo tombstone) {
        this(cacheName);
        this.tombstone = tombstone;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    public CompletionStage<Boolean> invokeAsync(ComponentRegistry registry) {
        registry.getIracTombstoneManager().running().removeTombstone(this.tombstone);
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 37;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        IracTombstoneInfo.writeTo(output, this.tombstone);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.tombstone = IracTombstoneInfo.readFrom(input);
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public String toString() {
        return "IracTombstoneCleanupCommand{cacheName=" + this.cacheName + ", tombstone=" + this.tombstone + '}';
    }

    public IracTombstoneInfo getTombstone() {
        return this.tombstone;
    }
}

