/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.Constants;
import org.infinispan.metrics.impl.BaseAdditionalMetrics;
import org.infinispan.metrics.impl.NameUtils;
import org.infinispan.metrics.impl.TimerTrackerImpl;
import org.infinispan.metrics.impl.VendorAdditionalMetrics;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class MetricsCollector
implements Constants {
    private static final Log log = LogFactory.getLog(MetricsCollector.class);
    private PrometheusMeterRegistry baseRegistry;
    private PrometheusMeterRegistry vendorRegistry;
    private Tag nodeTag;
    private Tag cacheManagerTag;
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    ComponentRef<Transport> transportRef;

    protected MetricsCollector() {
    }

    public PrometheusMeterRegistry getBaseRegistry() {
        return this.baseRegistry;
    }

    public PrometheusMeterRegistry getVendorRegistry() {
        return this.vendorRegistry;
    }

    @Start
    protected void start() {
        String nodeName;
        this.baseRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        this.baseRegistry.config().meterFilter((MeterFilter)new BaseFilter());
        new BaseAdditionalMetrics().bindTo((MeterRegistry)this.baseRegistry);
        this.vendorRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        this.vendorRegistry.config().meterFilter((MeterFilter)new VendorFilter());
        new VendorAdditionalMetrics().bindTo((MeterRegistry)this.vendorRegistry);
        Transport transport = this.transportRef.running();
        String string = nodeName = transport != null ? transport.getAddress().toString() : this.globalConfig.transport().nodeName();
        if (nodeName == null) {
            nodeName = MetricsCollector.generateRandomName();
        }
        this.nodeTag = Tag.of((String)"node", (String)nodeName);
        if (this.globalConfig.metrics().namesAsTags()) {
            this.cacheManagerTag = Tag.of((String)"cache_manager", (String)this.globalConfig.cacheManagerName());
        }
    }

    @Stop
    protected void stop() {
        try {
            if (this.baseRegistry != null) {
                this.baseRegistry.close();
                this.baseRegistry = null;
            }
        }
        finally {
            if (this.vendorRegistry != null) {
                this.vendorRegistry.close();
                this.vendorRegistry = null;
            }
        }
    }

    private static String generateRandomName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hostName == null) {
            try {
                hostName = InetAddress.getByName(null).getHostName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (hostName == null) {
            hostName = "localhost";
        } else {
            int dotPos = hostName.indexOf(46);
            if (dotPos > 0 && !Character.isDigit(hostName.charAt(0))) {
                hostName = hostName.substring(0, dotPos);
            }
        }
        int rand = 1 + ThreadLocalRandom.current().nextInt(65534);
        return hostName + '-' + rand;
    }

    public Set<Object> registerMetrics(Object instance, Collection<MBeanMetadata.AttributeMetadata> attributes, String namePrefix, String cacheName) {
        return this.registerMetrics(instance, attributes, namePrefix, cacheName, this.nodeTag);
    }

    public Set<Object> registerMetrics(Object instance, Collection<MBeanMetadata.AttributeMetadata> attributes, String namePrefix, String cacheName, String nodeName) {
        return this.registerMetrics(instance, attributes, namePrefix, cacheName, nodeName == null ? null : Tag.of((String)"node", (String)nodeName));
    }

    private Set<Object> registerMetrics(Object instance, Collection<MBeanMetadata.AttributeMetadata> attributes, String namePrefix, String cacheName, Tag nodeTag) {
        HashSet<Object> metricIds = new HashSet<Object>(attributes.size());
        GlobalMetricsConfiguration metricsCfg = this.globalConfig.metrics();
        int numTags = 1;
        if (this.cacheManagerTag != null) {
            ++numTags;
            if (cacheName != null) {
                ++numTags;
            }
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(numTags);
        if (nodeTag != null) {
            tags.add(nodeTag);
        }
        if (this.cacheManagerTag != null) {
            tags.add(this.cacheManagerTag);
            if (cacheName != null) {
                tags.add(Tag.of((String)"cache", (String)cacheName));
            }
        }
        for (MBeanMetadata.AttributeMetadata attr : attributes) {
            Meter.Id id;
            Supplier<?> getter = attr.getter(instance);
            Consumer<?> setter = attr.setter(instance);
            if (getter == null && setter == null) continue;
            String metricName = namePrefix + NameUtils.decamelize(attr.getName());
            if (getter != null) {
                if (!metricsCfg.gauges()) continue;
                Gauge gauge = Gauge.builder((String)metricName, getter).tags(tags).strongReference(true).description(attr.getDescription()).register((MeterRegistry)this.vendorRegistry);
                id = gauge.getId();
                if (log.isTraceEnabled()) {
                    log.tracef("Registering gauge metric %s", id);
                }
                metricIds.add(id);
                continue;
            }
            if (!metricsCfg.histograms()) continue;
            Timer timer = Timer.builder((String)metricName).tags(tags).description(attr.getDescription()).register((MeterRegistry)this.vendorRegistry);
            id = timer.getId();
            if (log.isTraceEnabled()) {
                log.tracef("Registering histogram metric %s", id);
            }
            setter.accept(new TimerTrackerImpl(timer));
            metricIds.add(id);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Registered %d metrics. Metric registry @%x contains %d metrics.", metricIds.size(), System.identityHashCode(this.vendorRegistry), this.vendorRegistry.getMeters().size());
        }
        return metricIds;
    }

    public void unregisterMetric(Object metricId) {
        if (this.vendorRegistry == null) {
            return;
        }
        Meter removed = this.vendorRegistry.remove((Meter.Id)metricId);
        if (log.isTraceEnabled()) {
            if (removed != null) {
                log.tracef("Unregistered metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.vendorRegistry), this.vendorRegistry.getMeters().size());
            } else {
                log.tracef("Could not remove unexisting metric \"%s\". Metric registry @%x contains %d metrics.", metricId, System.identityHashCode(this.vendorRegistry), this.vendorRegistry.getMeters().size());
            }
        }
    }

    private static class VendorFilter
    implements MeterFilter {
        private static final String PREFIX = "vendor.";

        private VendorFilter() {
        }

        public Meter.Id map(Meter.Id id) {
            return id.withName(PREFIX + id.getName());
        }
    }

    private static class BaseFilter
    implements MeterFilter {
        private static final String PREFIX = "base.";

        private BaseFilter() {
        }

        public Meter.Id map(Meter.Id id) {
            return id.withName(PREFIX + id.getName());
        }
    }
}

