/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.DataInput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryInfo;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.IndexNode;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.NonBlockingManager;
import org.infinispan.util.logging.LogFactory;

class Index {
    private static final Log log = LogFactory.getLog(Index.class, Log.class);
    private static final int GRACEFULLY = 1361759985;
    private static final int DIRTY = -787319028;
    private static final int INDEX_FILE_HEADER_SIZE = 34;
    private final NonBlockingManager nonBlockingManager;
    private final FileProvider fileProvider;
    private final Path indexDir;
    private final Compactor compactor;
    private final int minNodeSize;
    private final int maxNodeSize;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Segment[] segments;
    private final TimeService timeService;
    private final File indexSizeFile;
    public final AtomicLongArray sizePerSegment;
    private final FlowableProcessor<IndexRequest>[] flowableProcessors;

    public Index(NonBlockingManager nonBlockingManager, FileProvider fileProvider, Path indexDir, int segments, int cacheSegments, int minNodeSize, int maxNodeSize, TemporaryTable temporaryTable, Compactor compactor, TimeService timeService) throws IOException {
        this.nonBlockingManager = nonBlockingManager;
        this.fileProvider = fileProvider;
        this.compactor = compactor;
        this.timeService = timeService;
        this.indexDir = indexDir;
        this.minNodeSize = minNodeSize;
        this.maxNodeSize = maxNodeSize;
        this.sizePerSegment = new AtomicLongArray(cacheSegments);
        indexDir.toFile().mkdirs();
        this.indexSizeFile = new File(indexDir.toFile(), "index-count");
        boolean validCount = this.checkForExistingIndexSizeFile(segments, cacheSegments);
        this.segments = new Segment[segments];
        this.flowableProcessors = new FlowableProcessor[segments];
        for (int i = 0; i < segments; ++i) {
            Segment segment;
            UnicastProcessor flowableProcessor = UnicastProcessor.create();
            this.segments[i] = segment = new Segment(this, i, temporaryTable, validCount);
            this.flowableProcessors[i] = flowableProcessor.toSerialized();
        }
    }

    private boolean checkForExistingIndexSizeFile(int storeSegments, int cacheSegments) {
        boolean validCount = false;
        try (RandomAccessFile indexCount = new RandomAccessFile(this.indexSizeFile, "r");){
            int storeSegmentsCount = UnsignedNumeric.readUnsignedInt((DataInput)indexCount);
            int cacheSegmentsCount = UnsignedNumeric.readUnsignedInt((DataInput)indexCount);
            if (storeSegmentsCount == storeSegments && cacheSegmentsCount == cacheSegments) {
                for (int i = 0; i < this.sizePerSegment.length(); ++i) {
                    long value = UnsignedNumeric.readUnsignedLong((DataInput)indexCount);
                    this.sizePerSegment.set(i, value);
                }
                validCount = true;
            } else {
                log.tracef("Previous index file store segments " + storeSegmentsCount + " doesn't match configured store segments " + storeSegments + " or index file cache segments " + cacheSegmentsCount + " doesn't match configured cache segments " + cacheSegments, new Object[0]);
            }
        }
        catch (IOException e) {
            log.tracef("Encountered IOException %s while reading index count file, assuming index dirty", e.getMessage());
        }
        this.indexSizeFile.delete();
        return validCount;
    }

    public static byte[] toIndexKey(int cacheSegment, ByteBuffer buffer) {
        return Index.toIndexKey(cacheSegment, buffer.getBuf(), buffer.getOffset(), buffer.getLength());
    }

    static byte[] toIndexKey(int cacheSegment, byte[] bytes) {
        return Index.toIndexKey(cacheSegment, bytes, 0, bytes.length);
    }

    static byte[] toIndexKey(int cacheSegment, byte[] bytes, int offset, int length) {
        byte segmentBytes = UnsignedNumeric.sizeUnsignedInt((int)cacheSegment);
        byte[] indexKey = new byte[length + segmentBytes];
        UnsignedNumeric.writeUnsignedInt((byte[])indexKey, (int)0, (int)cacheSegment);
        System.arraycopy(bytes, 0, indexKey, segmentBytes + offset, length);
        return indexKey;
    }

    public boolean isLoaded() {
        for (Segment segment : this.segments) {
            if (segment.loaded) continue;
            return false;
        }
        return true;
    }

    public EntryRecord getRecord(Object key, int cacheSegment, ByteBuffer serializedKey) throws IOException {
        return this.getRecord(key, cacheSegment, Index.toIndexKey(cacheSegment, serializedKey), IndexNode.ReadOperation.GET_RECORD);
    }

    public EntryRecord getRecordEvenIfExpired(Object key, int cacheSegment, byte[] serializedKey) throws IOException {
        return this.getRecord(key, cacheSegment, Index.toIndexKey(cacheSegment, serializedKey), IndexNode.ReadOperation.GET_EXPIRED_RECORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryRecord getRecord(Object key, int cacheSegment, byte[] indexKey, IndexNode.ReadOperation readOperation) throws IOException {
        int segment = (key.hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryRecord entryRecord = (EntryRecord)IndexNode.applyOnLeaf(this.segments[segment], cacheSegment, indexKey, this.segments[segment].rootReadLock(), readOperation);
            return entryRecord;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPosition getPosition(Object key, int cacheSegment, ByteBuffer serializedKey) throws IOException {
        int segment = (key.hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryPosition entryPosition = (EntryPosition)IndexNode.applyOnLeaf(this.segments[segment], cacheSegment, Index.toIndexKey(cacheSegment, serializedKey), this.segments[segment].rootReadLock(), IndexNode.ReadOperation.GET_POSITION);
            return entryPosition;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryInfo getInfo(Object key, int cacheSegment, byte[] serializedKey) throws IOException {
        int segment = (key.hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.lock.readLock().lock();
        try {
            EntryInfo entryInfo = (EntryInfo)IndexNode.applyOnLeaf(this.segments[segment], cacheSegment, Index.toIndexKey(cacheSegment, serializedKey), this.segments[segment].rootReadLock(), IndexNode.ReadOperation.GET_INFO);
            return entryInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> clear() {
        this.lock.writeLock().lock();
        try {
            AggregateCompletionStage<Void> stage = CompletionStages.aggregateCompletionStage();
            for (FlowableProcessor<IndexRequest> processor : this.flowableProcessors) {
                IndexRequest clearRequest = IndexRequest.clearRequest();
                processor.onNext((Object)clearRequest);
                stage.dependsOn(clearRequest);
            }
            for (int i = 0; i < this.sizePerSegment.length(); ++i) {
                this.sizePerSegment.set(i, 0L);
            }
            CompletionStage<Void> completionStage = stage.freeze();
            return completionStage;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public CompletionStage<Object> handleRequest(IndexRequest indexRequest) {
        int processor = (indexRequest.getKey().hashCode() & Integer.MAX_VALUE) % this.segments.length;
        this.flowableProcessors[processor].onNext((Object)indexRequest);
        return indexRequest;
    }

    public void deleteFileAsync(int fileId) {
        AtomicInteger count = new AtomicInteger(this.flowableProcessors.length);
        for (FlowableProcessor<IndexRequest> flowableProcessor : this.flowableProcessors) {
            IndexRequest deleteFile = IndexRequest.syncRequest(() -> {
                if (count.decrementAndGet() == 0) {
                    this.fileProvider.deleteFile(fileId);
                    log.tracef("Deleted file %s", fileId);
                    this.compactor.releaseStats(fileId);
                }
            });
            flowableProcessor.onNext((Object)deleteFile);
        }
    }

    public CompletionStage<Void> stop() throws InterruptedException {
        for (FlowableProcessor<IndexRequest> flowableProcessor : this.flowableProcessors) {
            flowableProcessor.onComplete();
        }
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        for (Segment segment : this.segments) {
            aggregateCompletionStage.dependsOn(segment);
        }
        try {
            this.indexSizeFile.createNewFile();
            try (FileOutputStream indexCountStream = new FileOutputStream(this.indexSizeFile);){
                UnsignedNumeric.writeUnsignedInt((OutputStream)indexCountStream, (int)this.segments.length);
                UnsignedNumeric.writeUnsignedInt((OutputStream)indexCountStream, (int)this.sizePerSegment.length());
                for (int i = 0; i < this.sizePerSegment.length(); ++i) {
                    UnsignedNumeric.writeUnsignedLong((OutputStream)indexCountStream, (long)this.sizePerSegment.get(i));
                }
            }
        }
        catch (IOException e) {
            aggregateCompletionStage.dependsOn(CompletableFutures.completedExceptionFuture(e));
        }
        return aggregateCompletionStage.freeze();
    }

    public long approximateSize(IntSet cacheSegments) {
        long size = 0L;
        PrimitiveIterator.OfInt segIter = cacheSegments.iterator();
        while (segIter.hasNext()) {
            int cacheSegment = segIter.nextInt();
            if ((size += this.sizePerSegment.get(cacheSegment)) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxSeqId() throws IOException {
        long maxSeqId = 0L;
        this.lock.readLock().lock();
        try {
            for (Segment seg : this.segments) {
                maxSeqId = Math.max(maxSeqId, IndexNode.calculateMaxSeqId(seg, seg.rootReadLock()));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return maxSeqId;
    }

    public void start(Executor executor) {
        for (int i = 0; i < this.segments.length; ++i) {
            Segment segment = this.segments[i];
            this.flowableProcessors[i].observeOn(Schedulers.from((Executor)executor)).subscribe((Consumer)segment, segment::completeExceptionally, (Action)segment);
        }
    }

    <V> Flowable<EntryRecord> publish(IntSet cacheSegments, boolean loadValues) {
        return Flowable.fromArray((Object[])this.segments).concatMap(segment -> ((Segment)segment).root.publish(cacheSegments, loadValues));
    }

    static class IndexSpace {
        protected long offset;
        protected short length;

        IndexSpace(long offset, short length) {
            this.offset = offset;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexSpace)) {
                return false;
            }
            IndexSpace innerNode = (IndexSpace)o;
            return this.length == innerNode.length && this.offset == innerNode.offset;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.length;
            return result;
        }

        public String toString() {
            return String.format("[%d-%d(%d)]", this.offset, this.offset + (long)this.length, this.length);
        }
    }

    static class Segment
    extends CompletableFuture<Void>
    implements Consumer<IndexRequest>,
    Action {
        final Index index;
        private final TemporaryTable temporaryTable;
        private final TreeMap<Short, List<IndexSpace>> freeBlocks = new TreeMap();
        private final ReadWriteLock rootLock = new ReentrantReadWriteLock();
        private final boolean loaded;
        private final FileChannel indexFile;
        private long indexFileSize;
        private volatile IndexNode root;

        private Segment(Index index, int id, TemporaryTable temporaryTable, boolean attemptLoad) throws IOException {
            this.index = index;
            this.temporaryTable = temporaryTable;
            int segmentMax = temporaryTable.getSegmentMax();
            File indexFileFile = new File(index.indexDir.toFile(), "index." + id);
            this.indexFile = new RandomAccessFile(indexFileFile, "rw").getChannel();
            this.indexFile.position(0L);
            java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(34);
            int gracefulValue = -1;
            int segmentValue = -1;
            boolean validIndex = false;
            if (attemptLoad && this.indexFile.size() >= 34L && this.read(this.indexFile, buffer) && (gracefulValue = buffer.getInt(0)) == 1361759985 && (segmentValue = buffer.getInt(4)) == segmentMax) {
                validIndex = true;
            } else {
                log.tracef("Index %d is not valid must rebuild, gracefulValue=%s segments=%d attemptLoad=%s", new Object[]{id, gracefulValue, segmentValue, attemptLoad});
            }
            if (validIndex) {
                long rootOffset = buffer.getLong(8);
                short rootOccupied = buffer.getShort(16);
                long freeBlocksOffset = buffer.getLong(18);
                this.root = new IndexNode(this, rootOffset, rootOccupied);
                this.loadFreeBlocks(freeBlocksOffset);
                this.indexFileSize = freeBlocksOffset;
                this.loaded = true;
            } else {
                this.indexFile.truncate(0L);
                this.root = IndexNode.emptyWithLeaves(this);
                this.loaded = false;
                this.indexFileSize = 34L;
            }
            buffer.putInt(0, -787319028);
            buffer.position(0);
            buffer.limit(4);
            this.indexFile.position(0L);
            this.write(this.indexFile, buffer);
        }

        private long readUnsignedLong(DataInput input) throws IOException {
            return UnsignedNumeric.readUnsignedLong((DataInput)input);
        }

        private void write(FileChannel indexFile, java.nio.ByteBuffer buffer) throws IOException {
            do {
                int written;
                if ((written = indexFile.write(buffer)) >= 0) continue;
                throw new IllegalStateException("Cannot write to index file!");
            } while (buffer.position() < buffer.limit());
        }

        private boolean read(FileChannel indexFile, java.nio.ByteBuffer buffer) throws IOException {
            do {
                int read;
                if ((read = indexFile.read(buffer)) >= 0) continue;
                return false;
            } while (buffer.position() < buffer.limit());
            return true;
        }

        public void accept(final IndexRequest request) throws Throwable {
            IndexNode.OverwriteHook overwriteHook;
            IndexNode.RecordChange recordChange;
            if (log.isTraceEnabled()) {
                log.trace("Indexing " + request);
            }
            switch (request.getType()) {
                case CLEAR: {
                    this.root = IndexNode.emptyWithLeaves(this);
                    this.indexFile.truncate(0L);
                    this.indexFileSize = 34L;
                    this.freeBlocks.clear();
                    this.index.nonBlockingManager.complete(request, null);
                    return;
                }
                case SYNC_REQUEST: {
                    Runnable runnable = (Runnable)request.getKey();
                    runnable.run();
                    this.index.nonBlockingManager.complete(request, null);
                    return;
                }
                case MOVED: {
                    recordChange = IndexNode.RecordChange.MOVE;
                    overwriteHook = new IndexNode.OverwriteHook(){

                        @Override
                        public boolean check(int oldFile, int oldOffset) {
                            return (long)oldFile == request.getPrevFile() && oldOffset == request.getPrevOffset();
                        }

                        @Override
                        public void setOverwritten(int cacheSegment, boolean overwritten, int prevFile, int prevOffset) {
                            if (overwritten && request.getOffset() < 0 && request.getPrevOffset() >= 0) {
                                index.sizePerSegment.decrementAndGet(cacheSegment);
                            }
                        }
                    };
                    break;
                }
                case UPDATE: {
                    recordChange = IndexNode.RecordChange.INCREASE;
                    overwriteHook = (cacheSegment, overwritten, prevFile, prevOffset) -> {
                        this.index.nonBlockingManager.complete(request, overwritten);
                        if (request.getOffset() >= 0 && prevOffset < 0) {
                            this.index.sizePerSegment.incrementAndGet(cacheSegment);
                        } else if (request.getOffset() < 0 && prevOffset >= 0) {
                            this.index.sizePerSegment.decrementAndGet(cacheSegment);
                        }
                    };
                    break;
                }
                case DROPPED: {
                    recordChange = IndexNode.RecordChange.DECREASE;
                    overwriteHook = (cacheSegment, overwritten, prevFile, prevOffset) -> {
                        if (request.getPrevFile() == (long)prevFile && request.getPrevOffset() == prevOffset) {
                            this.index.sizePerSegment.decrementAndGet(cacheSegment);
                        }
                    };
                    break;
                }
                case FOUND_OLD: {
                    recordChange = IndexNode.RecordChange.INCREASE_FOR_OLD;
                    overwriteHook = IndexNode.NOOP_HOOK;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(request.toString());
                }
            }
            try {
                IndexNode.setPosition(this.root, request.getSegment(), request.getSerializedKey(), request.getFile(), request.getOffset(), request.getSize(), overwriteHook, recordChange);
            }
            catch (IllegalStateException e) {
                request.completeExceptionally(e);
            }
            this.temporaryTable.removeConditionally(request.getSegment(), request.getKey(), request.getFile(), request.getOffset());
            if (request.getType() != IndexRequest.Type.UPDATE) {
                this.index.nonBlockingManager.complete(request, null);
            }
        }

        public void run() throws IOException {
            try {
                IndexSpace rootSpace = this.allocateIndexSpace(this.root.length());
                this.root.store(rootSpace);
                this.indexFile.position(this.indexFileSize);
                java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(4);
                buffer.putInt(0, this.freeBlocks.size());
                this.write(this.indexFile, buffer);
                for (Map.Entry<Short, List<IndexSpace>> entry : this.freeBlocks.entrySet()) {
                    List<IndexSpace> list = entry.getValue();
                    int requiredSize = 8 + list.size() * 10;
                    buffer = buffer.capacity() < requiredSize ? java.nio.ByteBuffer.allocate(requiredSize) : buffer;
                    buffer.position(0);
                    buffer.limit(requiredSize);
                    buffer.putInt(entry.getKey().shortValue());
                    buffer.putInt(list.size());
                    for (IndexSpace space : list) {
                        buffer.putLong(space.offset);
                        buffer.putShort(space.length);
                    }
                    buffer.flip();
                    this.write(this.indexFile, buffer);
                }
                int headerWithoutMagic = 26;
                buffer = buffer.capacity() < headerWithoutMagic ? java.nio.ByteBuffer.allocate(headerWithoutMagic) : buffer;
                buffer.position(0);
                buffer.limit(headerWithoutMagic);
                buffer.putLong(0, rootSpace.offset);
                buffer.putShort(8, rootSpace.length);
                buffer.putLong(10, this.indexFileSize);
                this.indexFile.position(8L);
                this.write(this.indexFile, buffer);
                buffer.position(0);
                buffer.limit(8);
                buffer.putInt(0, 1361759985);
                buffer.putInt(4, this.temporaryTable.getSegmentMax());
                this.indexFile.position(0L);
                this.write(this.indexFile, buffer);
                this.complete(null);
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
            }
        }

        private void loadFreeBlocks(long freeBlocksOffset) throws IOException {
            this.indexFile.position(freeBlocksOffset);
            java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(8);
            buffer.limit(4);
            if (!this.read(this.indexFile, buffer)) {
                throw new IOException("Cannot read free blocks lists!");
            }
            int numLists = buffer.getInt(0);
            for (int i = 0; i < numLists; ++i) {
                buffer.position(0);
                buffer.limit(8);
                if (!this.read(this.indexFile, buffer)) {
                    throw new IOException("Cannot read free blocks lists!");
                }
                int blockLength = buffer.getInt(0);
                assert (blockLength <= Short.MAX_VALUE);
                int listSize = buffer.getInt(4);
                int requiredSize = 10 * listSize;
                buffer = buffer.capacity() < requiredSize ? java.nio.ByteBuffer.allocate(requiredSize) : buffer;
                buffer.position(0);
                buffer.limit(requiredSize);
                if (!this.read(this.indexFile, buffer)) {
                    throw new IOException("Cannot read free blocks lists!");
                }
                buffer.flip();
                ArrayList<IndexSpace> list = new ArrayList<IndexSpace>(listSize);
                for (int j = 0; j < listSize; ++j) {
                    list.add(new IndexSpace(buffer.getLong(), buffer.getShort()));
                }
                this.freeBlocks.put((short)blockLength, list);
            }
        }

        public FileChannel getIndexFile() {
            return this.indexFile;
        }

        public FileProvider getFileProvider() {
            return this.index.fileProvider;
        }

        public Compactor getCompactor() {
            return this.index.compactor;
        }

        public IndexNode getRoot() {
            return this.root;
        }

        public void setRoot(IndexNode root) {
            this.rootLock.writeLock().lock();
            this.root = root;
            this.rootLock.writeLock().unlock();
        }

        public int getMaxNodeSize() {
            return this.index.maxNodeSize;
        }

        public int getMinNodeSize() {
            return this.index.minNodeSize;
        }

        IndexSpace allocateIndexSpace(short length) {
            Map.Entry<Short, List<IndexSpace>> entry = this.freeBlocks.ceilingEntry(length);
            if (entry == null || entry.getValue().isEmpty()) {
                long oldSize = this.indexFileSize;
                this.indexFileSize += (long)length;
                return new IndexSpace(oldSize, length);
            }
            return entry.getValue().remove(entry.getValue().size() - 1);
        }

        void freeIndexSpace(long offset, short length) {
            if (length <= 0) {
                throw new IllegalArgumentException("Offset=" + offset + ", length=" + length);
            }
            if (offset + (long)length < this.indexFileSize) {
                this.freeBlocks.computeIfAbsent(length, k -> new ArrayList()).add(new IndexSpace(offset, length));
            } else {
                this.indexFileSize -= (long)length;
                try {
                    this.indexFile.truncate(this.indexFileSize);
                }
                catch (IOException e) {
                    log.cannotTruncateIndex(e);
                }
            }
        }

        Lock rootReadLock() {
            return this.rootLock.readLock();
        }

        public TimeService getTimeService() {
            return this.index.timeService;
        }
    }
}

