/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.util.concurrent.CountDownRunnable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.irac.IracManagerKeyState;
import org.infinispan.xsite.irac.IracXSiteBackup;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;

public class IracResponseCollector
implements Runnable {
    private static final Log log = LogFactory.getLog(IracResponseCollector.class);
    private static final AtomicReferenceFieldUpdater<IracResponseCollector, Result> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(IracResponseCollector.class, Result.class, "result");
    private volatile Result result = Result.OK;
    private final String cacheName;
    private final IracManagerKeyState state;
    private final CountDownRunnable countDownRunnable;
    private final IracResponseCompleted notifier;

    public IracResponseCollector(String cacheName, IracManagerKeyState state, IracResponseCompleted notifier) {
        this.cacheName = cacheName;
        this.state = state;
        this.notifier = Objects.requireNonNull(notifier);
        this.countDownRunnable = new CountDownRunnable(this);
    }

    public void dependsOn(IracXSiteBackup backup, CompletionStage<Void> request) {
        this.countDownRunnable.increment();
        request.whenComplete((unused, throwable) -> this.onResponse(backup, (Throwable)throwable));
    }

    public void freeze() {
        this.countDownRunnable.freeze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(IracXSiteBackup backup, Throwable throwable) {
        boolean trace = log.isTraceEnabled();
        try {
            if (throwable != null) {
                if (DefaultTakeOfflineManager.isCommunicationError(throwable)) {
                    RESULT_UPDATER.set(this, Result.NETWORK_EXCEPTION);
                } else {
                    RESULT_UPDATER.compareAndSet(this, Result.OK, Result.REMOTE_EXCEPTION);
                }
                if (backup.logExceptions()) {
                    log.warnXsiteBackupFailed(this.cacheName, backup.getSiteName(), throwable);
                } else if (trace) {
                    log.tracef(throwable, "Encountered issues while backing up data for cache %s to site %s", this.cacheName, backup.getSiteName());
                }
            } else if (trace) {
                log.tracef("Receive response from %s (%d missing). New result=%s", backup.getSiteName(), this.countDownRunnable.missing(), (Object)this.result);
            }
        }
        finally {
            this.countDownRunnable.decrement();
        }
    }

    @Override
    public void run() {
        if (log.isTraceEnabled()) {
            log.tracef("All responses received for state %s. global result is %s", this.state, (Object)this.result);
        }
        this.notifier.onResponseCompleted(this.state, this.result);
    }

    @FunctionalInterface
    public static interface IracResponseCompleted {
        public void onResponseCompleted(IracManagerKeyState var1, Result var2);
    }

    public static enum Result {
        OK,
        REMOTE_EXCEPTION,
        NETWORK_EXCEPTION;

    }
}

