/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.Locale;

public final class ProtocolVersion
extends Enum<ProtocolVersion> {
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_40 = new ProtocolVersion(4, 0);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_AUTO = new ProtocolVersion(4, 0);
    private static final ProtocolVersion[] VERSIONS;
    public static final ProtocolVersion DEFAULT_PROTOCOL_VERSION;
    public static final ProtocolVersion HIGHEST_PROTOCOL_VERSION;
    private final String textVersion;
    private final int version;
    private static final /* synthetic */ ProtocolVersion[] $VALUES;

    public static ProtocolVersion[] values() {
        return (ProtocolVersion[])$VALUES.clone();
    }

    public static ProtocolVersion valueOf(String name) {
        return Enum.valueOf(ProtocolVersion.class, name);
    }

    private ProtocolVersion(int major, int minor) {
        assert (minor < 10);
        this.textVersion = String.format(Locale.ROOT, "%d.%d", major, minor);
        this.version = major * 10 + minor;
    }

    public String toString() {
        return this.textVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public static ProtocolVersion parseVersion(String version) {
        for (ProtocolVersion v : VERSIONS) {
            if (!v.textVersion.equals(version)) continue;
            return v;
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    public static ProtocolVersion getBestVersion(int version) {
        for (int i = VERSIONS.length - 2; i >= 0; --i) {
            if (version < ProtocolVersion.VERSIONS[i].version) continue;
            return VERSIONS[i];
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    static {
        $VALUES = new ProtocolVersion[]{PROTOCOL_VERSION_40, PROTOCOL_VERSION_AUTO};
        VERSIONS = ProtocolVersion.values();
        DEFAULT_PROTOCOL_VERSION = PROTOCOL_VERSION_AUTO;
        HIGHEST_PROTOCOL_VERSION = VERSIONS[VERSIONS.length - 2];
    }
}

