/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class AuthMechListOperation
extends HotRodOperation<List<String>> {
    private final Channel channel;
    private int mechCount = -1;
    private List<String> result;

    public AuthMechListOperation(OperationContext operationContext, Channel channel) {
        super(operationContext, (short)33, (short)34, CacheOptions.DEFAULT);
        this.channel = channel;
    }

    @Override
    public CompletableFuture<List<String>> execute() {
        if (!this.channel.isActive()) {
            throw Log.HOTROD.channelInactive(this.channel.remoteAddress(), this.channel.remoteAddress());
        }
        this.scheduleRead(this.channel);
        this.sendHeader(this.channel);
        return this;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (this.mechCount < 0) {
            this.mechCount = ByteBufUtil.readVInt(buf);
            this.result = new ArrayList<String>(this.mechCount);
            decoder.checkpoint();
        }
        while (this.result.size() < this.mechCount) {
            this.result.add(ByteBufUtil.readString(buf));
            decoder.checkpoint();
        }
        this.complete(this.result);
    }
}

