/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.transaction.xa.Xid;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.io.SignedNumeric;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.transaction.manager.RemoteXid;

public class RecoveryOperation
extends RetryOnFailureOperation<Collection<Xid>> {
    public RecoveryOperation(OperationContext operationContext) {
        super(operationContext, (short)123, (short)124, CacheOptions.DEFAULT, null);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (status != 0) {
            this.complete(Collections.emptyList());
            return;
        }
        int size = ByteBufUtil.readVInt(buf);
        if (size == 0) {
            this.complete(Collections.emptyList());
            return;
        }
        ArrayList<XidImpl> xids = new ArrayList<XidImpl>(size);
        for (int i = 0; i < size; ++i) {
            int formatId = SignedNumeric.decode((int)ByteBufUtil.readVInt(buf));
            byte[] globalId = ByteBufUtil.readArray(buf);
            byte[] branchId = ByteBufUtil.readArray(buf);
            xids.add(RemoteXid.create((int)formatId, (byte[])globalId, (byte[])branchId));
        }
        this.complete(xids);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.estimateSize());
        this.operationContext.getCodec().writeHeader(buf, this.header);
        channel.writeAndFlush((Object)buf);
    }

    private int estimateSize() {
        return this.operationContext.getCodec().estimateHeaderSize(this.header);
    }
}

