/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.net.SocketAddress;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLParameters;
import javax.security.auth.Subject;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.SaslUtils;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.configuration.SslConfiguration;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.transport.netty.ActivationHandler;
import org.infinispan.hotrod.impl.transport.netty.AuthHandler;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.hotrod.impl.transport.netty.ChannelPool;
import org.infinispan.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.impl.transport.netty.IdleStateHandlerProvider;
import org.infinispan.hotrod.impl.transport.netty.InitialPingHandler;
import org.infinispan.hotrod.impl.transport.netty.SslHandshakeExceptionHandler;

class ChannelInitializer
extends io.netty.channel.ChannelInitializer<Channel> {
    private static final Log log = LogFactory.getLog(ChannelInitializer.class);
    private final Bootstrap bootstrap;
    private final SocketAddress unresolvedAddress;
    private final CacheOperationsFactory cacheOperationsFactory;
    private final HotRodConfiguration configuration;
    private final ChannelFactory channelFactory;
    private ChannelPool channelPool;
    private volatile boolean isFirstPing = true;
    private static final Provider[] SECURITY_PROVIDERS;

    ChannelInitializer(Bootstrap bootstrap, SocketAddress unresolvedAddress, CacheOperationsFactory cacheOperationsFactory, HotRodConfiguration configuration, ChannelFactory channelFactory) {
        this.bootstrap = bootstrap;
        this.unresolvedAddress = unresolvedAddress;
        this.cacheOperationsFactory = cacheOperationsFactory;
        this.configuration = configuration;
        this.channelFactory = channelFactory;
    }

    CompletableFuture<Channel> createChannel() {
        ChannelFuture connect = this.bootstrap.clone().connect();
        ActivationFuture activationFuture = new ActivationFuture();
        connect.addListener((GenericFutureListener)activationFuture);
        return activationFuture;
    }

    protected void initChannel(Channel channel) throws Exception {
        AuthenticationConfiguration authentication;
        if (log.isTraceEnabled()) {
            log.tracef("Created channel %s", channel);
        }
        if (this.configuration.security().ssl().enabled()) {
            this.initSsl(channel);
        }
        if ((authentication = this.configuration.security().authentication()).enabled()) {
            this.initAuthentication(channel, authentication);
        }
        if (this.configuration.connectionPool().minEvictableIdleTime() > 0L) {
            channel.pipeline().addLast("idle-state-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, this.configuration.connectionPool().minEvictableIdleTime(), TimeUnit.MILLISECONDS));
        }
        ChannelRecord channelRecord = new ChannelRecord(this.unresolvedAddress, this.channelPool);
        channel.attr(ChannelRecord.KEY).set((Object)channelRecord);
        if (this.isFirstPing) {
            this.isFirstPing = false;
            channel.pipeline().addLast("initial-ping-handler", (ChannelHandler)new InitialPingHandler(this.cacheOperationsFactory.newPingOperation(false)));
        } else {
            channel.pipeline().addLast("activation-handler", (ChannelHandler)ActivationHandler.INSTANCE);
        }
        channel.pipeline().addLast("header-decoder", (ChannelHandler)new HeaderDecoder(this.cacheOperationsFactory.getDefaultContext()));
        if (this.configuration.connectionPool().minEvictableIdleTime() > 0L) {
            channel.pipeline().addLast("idle-state-handler-provider", (ChannelHandler)new IdleStateHandlerProvider(this.configuration.connectionPool().minIdle(), this.channelPool));
        }
    }

    private void initSsl(Channel channel) {
        JdkSslContext sslContext;
        SslConfiguration ssl = this.configuration.security().ssl();
        if (ssl.sslContext() == null) {
            SslContextBuilder builder = SslContextBuilder.forClient();
            try {
                if (ssl.keyStoreFileName() != null) {
                    builder.keyManager(new SslContextFactory().keyStoreFileName(ssl.keyStoreFileName()).keyStoreType(ssl.keyStoreType()).keyStorePassword(ssl.keyStorePassword()).keyAlias(ssl.keyAlias()).classLoader(HotRod.class.getClassLoader()).provider(ssl.provider()).getKeyManagerFactory());
                }
                if (ssl.trustStoreFileName() != null) {
                    if ("pem".equalsIgnoreCase(ssl.trustStoreType())) {
                        builder.trustManager(new File(ssl.trustStoreFileName()));
                    } else {
                        builder.trustManager(new SslContextFactory().trustStoreFileName(ssl.trustStoreFileName()).trustStoreType(ssl.trustStoreType()).trustStorePassword(ssl.trustStorePassword()).provider(ssl.provider()).classLoader(HotRod.class.getClassLoader()).getTrustManagerFactory());
                    }
                }
                if (ssl.protocol() != null) {
                    builder.protocols(new String[]{ssl.protocol()});
                }
                if (ssl.ciphers() != null) {
                    builder.ciphers(Arrays.asList(ssl.ciphers()));
                }
                if (ssl.provider() != null) {
                    Provider provider = SslContextFactory.findProvider((String)ssl.provider(), (String)SslContext.class.getSimpleName(), (String)"TLS");
                    builder.sslContextProvider(provider);
                }
                sslContext = builder.build();
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        } else {
            sslContext = new JdkSslContext(ssl.sslContext(), true, ClientAuth.NONE);
        }
        SslHandler sslHandler = sslContext.newHandler(channel.alloc(), ssl.sniHostName(), -1);
        if (ssl.sniHostName() != null) {
            SSLParameters sslParameters = sslHandler.engine().getSSLParameters();
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(ssl.sniHostName())));
            sslHandler.engine().setSSLParameters(sslParameters);
        }
        channel.pipeline().addFirst(new ChannelHandler[]{sslHandler, SslHandshakeExceptionHandler.INSTANCE});
    }

    private void initAuthentication(Channel channel, AuthenticationConfiguration authentication) throws PrivilegedActionException, SaslException {
        SaslClientFactory scf = this.getSaslClientFactory(authentication);
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        Principal principal = sslHandler != null ? sslHandler.engine().getSession().getLocalPrincipal() : null;
        String authorizationId = principal != null ? principal.getName() : null;
        SaslClient saslClient = authentication.clientSubject() != null ? Subject.doAs(authentication.clientSubject(), () -> scf.createSaslClient(new String[]{authentication.saslMechanism()}, authorizationId, "hotrod", authentication.serverName(), authentication.saslProperties(), authentication.callbackHandler())) : scf.createSaslClient(new String[]{authentication.saslMechanism()}, authorizationId, "hotrod", authentication.serverName(), authentication.saslProperties(), authentication.callbackHandler());
        channel.pipeline().addLast("auth-handler", (ChannelHandler)new AuthHandler(authentication, saslClient, this.cacheOperationsFactory));
    }

    private SaslClientFactory getSaslClientFactory(AuthenticationConfiguration configuration) {
        if (log.isTraceEnabled()) {
            log.tracef("Attempting to load SaslClientFactory implementation with mech=%s, props=%s", configuration.saslMechanism(), configuration.saslProperties());
        }
        Collection clientFactories = SaslUtils.getSaslClientFactories((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (Provider[])SECURITY_PROVIDERS, (boolean)true);
        for (SaslClientFactory saslFactory : clientFactories) {
            try {
                String[] saslFactoryMechs;
                for (String supportedMech : saslFactoryMechs = saslFactory.getMechanismNames(configuration.saslProperties())) {
                    if (!supportedMech.equals(configuration.saslMechanism())) continue;
                    if (log.isTraceEnabled()) {
                        log.tracef("Loaded SaslClientFactory: %s", saslFactory.getClass().getName());
                    }
                    return saslFactory;
                }
            }
            catch (Throwable t) {
                log.tracef("Error while trying to obtain mechanism names supported by SaslClientFactory: %s", saslFactory.getClass().getName());
            }
        }
        throw new IllegalStateException("SaslClientFactory implementation not found");
    }

    void setChannelPool(ChannelPool channelPool) {
        this.channelPool = channelPool;
    }

    static {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (String name : Arrays.asList("org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider", "org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider", "org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider", "org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider", "org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider", "org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider", "org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider")) {
            Provider provider = (Provider)Util.getInstance((String)name, (ClassLoader)HotRod.class.getClassLoader());
            providers.add(provider);
        }
        SECURITY_PROVIDERS = providers.toArray(new Provider[0]);
    }

    private static class ActivationFuture
    extends CompletableFuture<Channel>
    implements ChannelFutureListener,
    BiConsumer<Channel, Throwable> {
        private ActivationFuture() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                ChannelRecord.of(channel).whenComplete((BiConsumer)this);
            } else {
                this.completeExceptionally(future.cause());
            }
        }

        @Override
        public void accept(Channel channel, Throwable throwable) {
            if (throwable != null) {
                this.completeExceptionally(throwable);
            } else {
                this.complete(channel);
            }
        }
    }
}

