/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.topology;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.util.Immutables;
import org.infinispan.hotrod.configuration.ClientIntelligence;

public class ClusterInfo {
    private final String clusterName;
    private final List<InetSocketAddress> servers;
    private final int topologyAge;
    private final ClientIntelligence intelligence;
    private final String sniHostName;

    public ClusterInfo(String clusterName, List<InetSocketAddress> servers, ClientIntelligence intelligence, String sniHostName) {
        this(clusterName, servers, -1, intelligence, sniHostName);
    }

    private ClusterInfo(String clusterName, List<InetSocketAddress> servers, int topologyAge, ClientIntelligence intelligence, String sniHostName) {
        this.clusterName = clusterName;
        this.servers = Immutables.immutableListCopy(servers);
        this.topologyAge = topologyAge;
        this.intelligence = Objects.requireNonNull(intelligence);
        this.sniHostName = sniHostName;
    }

    public ClusterInfo withTopologyAge(int topologyAge) {
        return new ClusterInfo(this.clusterName, this.servers, topologyAge, this.intelligence, this.sniHostName);
    }

    public String getName() {
        return this.clusterName;
    }

    public List<InetSocketAddress> getInitialServers() {
        return this.servers;
    }

    public int getTopologyAge() {
        return this.topologyAge;
    }

    public ClientIntelligence getIntelligence() {
        return this.intelligence;
    }

    public String getSniHostName() {
        return this.sniHostName;
    }

    public String toString() {
        return "ClusterInfo{name='" + this.clusterName + "', servers=" + String.valueOf(this.servers) + ", age=" + this.topologyAge + ", intelligence=" + String.valueOf((Object)this.intelligence) + ", sniHostName=" + this.sniHostName + "}";
    }
}

