/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.configuration.ProtocolVersion;
import org.infinispan.hotrod.exceptions.InvalidResponseException;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class FaultTolerantPingOperation
extends RetryOnFailureOperation<PingResponse> {
    private final PingResponse.Decoder responseBuilder;

    protected FaultTolerantPingOperation(OperationContext operationContext, CacheOptions options) {
        super(operationContext, (short)23, (short)24, options, null);
        this.responseBuilder = new PingResponse.Decoder(operationContext.getConfiguration().version());
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.sendHeaderAndRead(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        PingResponse pingResponse;
        this.responseBuilder.processResponse(this.operationContext.getCodec(), buf, decoder);
        if (HotRodConstants.isSuccess(status)) {
            pingResponse = this.responseBuilder.build(status);
            if (pingResponse.getVersion() != null && this.operationContext.getConfiguration().version() == ProtocolVersion.PROTOCOL_VERSION_AUTO) {
                this.operationContext.setCodec(Codec.forProtocol(pingResponse.getVersion()));
            }
        } else {
            String hexStatus = Integer.toHexString(status);
            if (log.isTraceEnabled()) {
                log.tracef("Unknown response status: %s", hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        this.complete(pingResponse);
    }

    @Override
    protected Throwable handleException(Throwable cause, Channel channel, SocketAddress address) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingResponse pingResponse = new PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
            return null;
        }
        return super.handleException(cause, channel, address);
    }

    @Override
    protected void reset() {
        super.reset();
        this.responseBuilder.reset();
    }
}

