/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.cache;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.hotrod.impl.HotRodTransport;
import org.infinispan.hotrod.impl.cache.RemoteCacheImpl;
import org.infinispan.hotrod.impl.logging.Log;

public interface MBeanHelper
extends AutoCloseable {
    public void register(RemoteCacheImpl<?, ?> var1);

    public void unregister(RemoteCacheImpl<?, ?> var1);

    @Override
    public void close();

    public static MBeanHelper getInstance(HotRodTransport transport) {
        if (transport.getConfiguration().statistics().jmxEnabled()) {
            return new Impl(transport);
        }
        return new NoOp();
    }

    public static class Impl
    implements MBeanHelper {
        private final MBeanServer mBeanServer;
        private final ObjectName transportMBean;
        private final Map<String, ObjectName> cacheMBeans = new HashMap<String, ObjectName>();

        Impl(HotRodTransport transport) {
            StatisticsConfiguration configuration = transport.getConfiguration().statistics();
            try {
                this.mBeanServer = configuration.mbeanServerLookup().getMBeanServer();
                this.transportMBean = new ObjectName(String.format("%s:type=HotRodClient,name=%s", configuration.jmxDomain(), configuration.jmxName()));
                this.mBeanServer.registerMBean(this, this.transportMBean);
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxRegistrationFailure(e);
            }
        }

        @Override
        public void close() {
            this.unregister(this.transportMBean);
        }

        @Override
        public void register(RemoteCacheImpl<?, ?> remoteCache) {
            StatisticsConfiguration configuration = remoteCache.getHotRodTransport().getConfiguration().statistics();
            try {
                ObjectName mbeanObjectName = new ObjectName(String.format("%s:type=HotRodClient,name=%s,cache=%s", this.transportMBean.getDomain(), configuration.jmxName(), remoteCache.getName()));
                this.mBeanServer.registerMBean(remoteCache.getClientStatistics(), mbeanObjectName);
                this.cacheMBeans.put(remoteCache.getName(), mbeanObjectName);
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxRegistrationFailure(e);
            }
        }

        @Override
        public void unregister(RemoteCacheImpl<?, ?> remoteCache) {
            this.unregister(this.cacheMBeans.remove(remoteCache.getName()));
        }

        private void unregister(ObjectName objectName) {
            if (objectName != null) {
                try {
                    if (this.mBeanServer.isRegistered(objectName)) {
                        this.mBeanServer.unregisterMBean(objectName);
                    } else {
                        Log.HOTROD.debugf("MBean not registered: %s", objectName);
                    }
                }
                catch (Exception e) {
                    throw Log.HOTROD.jmxUnregistrationFailure(e);
                }
            }
        }
    }

    public static class NoOp
    implements MBeanHelper {
        @Override
        public void close() {
        }

        @Override
        public void register(RemoteCacheImpl<?, ?> remoteCache) {
        }

        @Override
        public void unregister(RemoteCacheImpl<?, ?> remoteCache) {
        }
    }
}

