/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.hotrod.impl.transport.netty.HotRodClientDecoder;

public abstract class ClientListenerOperation
extends RetryOnFailureOperation<SocketAddress> {
    public final byte[] listenerId;
    public final Object listener;
    protected SocketAddress address;

    protected ClientListenerOperation(OperationContext operationContext, short requestCode, short responseCode, CacheOptions options, byte[] listenerId, DataFormat dataFormat, Object listener) {
        super(operationContext, requestCode, responseCode, options, dataFormat);
        this.listenerId = listenerId;
        this.listener = listener;
    }

    protected static byte[] generateListenerId() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] listenerId = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(listenerId);
        bb.putLong(random.nextLong());
        bb.putLong(random.nextLong());
        return listenerId;
    }

    public String getCacheName() {
        return this.operationContext.getCacheName();
    }

    @Override
    protected final void executeOperation(Channel channel) {
        if (!channel.isActive()) {
            this.channelInactive(channel);
            return;
        }
        this.address = ChannelRecord.of(channel).getUnresolvedAddress();
        this.actualExecute(channel);
    }

    protected abstract void actualExecute(Channel var1);

    protected void cleanup(Channel channel) {
        channel.eventLoop().execute(() -> {
            HotRodClientDecoder decoder;
            if (!this.operationContext.getCodec().allowOperationsAndEvents() && channel.isOpen()) {
                this.operationContext.getChannelFactory().releaseChannel(channel);
            }
            if ((decoder = (HotRodClientDecoder)channel.pipeline().get(HotRodClientDecoder.class)) != null) {
                decoder.removeListener(this.listenerId);
            }
        });
    }

    @Override
    public void releaseChannel(Channel channel) {
        if (this.operationContext.getCodec().allowOperationsAndEvents()) {
            super.releaseChannel(channel);
        }
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (!HotRodConstants.isSuccess(status)) {
            this.operationContext.getListenerNotifier().removeClientListener(this.listenerId);
            throw Log.HOTROD.failedToAddListener(this.listener, status);
        }
        decoder.addListener(this.listenerId);
        this.operationContext.getListenerNotifier().startClientListener(this.listenerId);
        this.complete(this.address);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        if (!this.isDone()) {
            this.operationContext.getListenerNotifier().removeClientListener(this.listenerId);
        }
        return super.completeExceptionally(ex);
    }

    public void postponeTimeout(Channel channel) {
        assert (!this.isDone());
        this.timeoutFuture.cancel(false);
        this.timeoutFuture = null;
        this.scheduleTimeout(channel);
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append("listenerId=").append(Util.printArray((byte[])this.listenerId));
    }

    public abstract ClientListenerOperation copy();
}

