/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.predicate.AndJanusPredicate;
import org.janusgraph.graphdb.predicate.OrJanusPredicate;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.condition.Not;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class QueryUtil {
    public static int adjustLimitForTxModifications(StandardJanusGraphTx tx, int uncoveredAndConditions, int limit) {
        assert (limit > 0 && limit <= 1000000000);
        assert (uncoveredAndConditions >= 0);
        if (uncoveredAndConditions > 0) {
            int maxMultiplier = Integer.MAX_VALUE / limit;
            limit *= Math.min(maxMultiplier, (int)Math.pow(2.0, uncoveredAndConditions));
        }
        if (tx.hasModifications()) {
            limit += Math.min(Integer.MAX_VALUE - limit, 5);
        }
        return limit;
    }

    public static int convertLimit(long limit) {
        assert (limit >= 0L);
        if (limit >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)limit;
    }

    public static int mergeLowLimits(int limit1, int limit2) {
        assert (limit1 >= 0 && limit2 >= 0);
        return Math.max(limit1, limit2);
    }

    public static int mergeHighLimits(int limit1, int limit2) {
        assert (limit1 >= 0 && limit2 >= 0);
        return Math.min(limit1, limit2);
    }

    public static InternalRelationType getType(StandardJanusGraphTx tx, String typeName) {
        RelationType t = tx.getRelationType(typeName);
        if (t == null && !tx.getConfiguration().getAutoSchemaMaker().ignoreUndefinedQueryTypes()) {
            throw new IllegalArgumentException("Undefined type used in query: " + typeName);
        }
        return (InternalRelationType)t;
    }

    public static Iterable<JanusGraphVertex> getVertices(StandardJanusGraphTx tx, PropertyKey key, Object equalityCondition) {
        return tx.query().has(key, (JanusGraphPredicate)Cmp.EQUAL, equalityCondition).vertices();
    }

    public static Iterable<JanusGraphVertex> getVertices(StandardJanusGraphTx tx, String key, Object equalityCondition) {
        return tx.query().has(key, (JanusGraphPredicate)Cmp.EQUAL, equalityCondition).vertices();
    }

    public static Iterable<JanusGraphEdge> getEdges(StandardJanusGraphTx tx, PropertyKey key, Object equalityCondition) {
        return tx.query().has(key, (JanusGraphPredicate)Cmp.EQUAL, equalityCondition).edges();
    }

    public static Iterable<JanusGraphEdge> getEdges(StandardJanusGraphTx tx, String key, Object equalityCondition) {
        return tx.query().has(key, (JanusGraphPredicate)Cmp.EQUAL, equalityCondition).edges();
    }

    public static boolean isQueryNormalForm(Condition<?> condition) {
        if (QueryUtil.isQNFLiteralOrNot(condition)) {
            return true;
        }
        if (!(condition instanceof And)) {
            return false;
        }
        for (Condition child : ((And)condition).getChildren()) {
            if (QueryUtil.isQNFLiteralOrNot(child)) continue;
            if (child instanceof Or) {
                for (Condition child2 : ((Or)child).getChildren()) {
                    if (QueryUtil.isQNFLiteralOrNot(child2)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean isQNFLiteralOrNot(Condition<?> condition) {
        if (!(condition instanceof Not)) {
            return QueryUtil.isQNFLiteral(condition);
        }
        Condition child = ((Not)condition).getChild();
        return QueryUtil.isQNFLiteral(child) && (!(child instanceof PredicateCondition) || !((PredicateCondition)child).getPredicate().hasNegation());
    }

    private static boolean isQNFLiteral(Condition<?> condition) {
        return condition.getType() == Condition.Type.LITERAL && (!(condition instanceof PredicateCondition) || ((PredicateCondition)condition).getPredicate().isQNF());
    }

    public static <E extends JanusGraphElement> Condition<E> simplifyQNF(Condition<E> condition) {
        Condition child;
        Preconditions.checkArgument((boolean)QueryUtil.isQueryNormalForm(condition));
        if (condition.numChildren() == 1 && (child = (Condition)((And)condition).get(0)).getType() == Condition.Type.LITERAL) {
            return child;
        }
        return condition;
    }

    public static boolean isEmpty(Condition<?> condition) {
        return condition.getType() != Condition.Type.LITERAL && condition.numChildren() == 0;
    }

    public static <E extends JanusGraphElement> And<E> constraints2QNF(StandardJanusGraphTx tx, List<PredicateCondition<String, E>> constraints) {
        And conditions = new And(constraints.size() + 4);
        for (PredicateCondition<String, E> atom : constraints) {
            Or nested;
            Collection values;
            InternalRelationType type = QueryUtil.getType(tx, atom.getKey());
            if (type == null) {
                if (atom.getPredicate() == Cmp.EQUAL && atom.getValue() == null || atom.getPredicate() == Cmp.NOT_EQUAL && atom.getValue() != null) continue;
                return null;
            }
            Object value = atom.getValue();
            JanusGraphPredicate predicate = atom.getPredicate();
            if (type.isPropertyKey()) {
                PropertyKey key = (PropertyKey)((Object)type);
                assert (predicate.isValidCondition(value));
                Preconditions.checkArgument((key.dataType() == Object.class || predicate.isValidValueType(key.dataType()) ? 1 : 0) != 0, (Object)"Data type of key is not compatible with condition");
            } else {
                Preconditions.checkArgument((boolean)((EdgeLabel)((Object)type)).isUnidirected());
                Preconditions.checkArgument((boolean)predicate.isValidValueType(JanusGraphVertex.class), (Object)"Data type of key is not compatible with condition");
            }
            if (predicate instanceof Contain) {
                values = (Collection)value;
                if (predicate == Contain.NOT_IN) {
                    if (values.isEmpty()) continue;
                    for (Object inValue : values) {
                        QueryUtil.addConstraint((RelationType)type, Cmp.NOT_EQUAL, inValue, conditions, tx);
                    }
                    continue;
                }
                Preconditions.checkArgument((predicate == Contain.IN ? 1 : 0) != 0);
                if (values.isEmpty()) {
                    return null;
                }
                if (values.size() == 1) {
                    QueryUtil.addConstraint((RelationType)type, Cmp.EQUAL, values.iterator().next(), conditions, tx);
                    continue;
                }
                nested = new Or(values.size());
                for (Object invalue : values) {
                    QueryUtil.addConstraint((RelationType)type, Cmp.EQUAL, invalue, nested, tx);
                }
                conditions.add(nested);
                continue;
            }
            if (predicate instanceof AndJanusPredicate) {
                if (QueryUtil.addConstraint((RelationType)type, (AndJanusPredicate)predicate, (List<Object>)((List)value), conditions, tx) != null) continue;
                return null;
            }
            if (predicate instanceof OrJanusPredicate) {
                values = (List)value;
                nested = QueryUtil.addConstraint((RelationType)type, (OrJanusPredicate)predicate, (List<Object>)values, new Or(values.size()), tx);
                if (nested == null) {
                    return null;
                }
                conditions.add(nested);
                continue;
            }
            QueryUtil.addConstraint((RelationType)type, predicate, value, conditions, tx);
        }
        return conditions;
    }

    private static <E extends JanusGraphElement> And<E> addConstraint(RelationType type, AndJanusPredicate predicate, List<Object> values, And<E> and, StandardJanusGraphTx tx) {
        for (int i = 0; i < values.size(); ++i) {
            JanusGraphPredicate janusGraphPredicate = (JanusGraphPredicate)predicate.get(i);
            if (janusGraphPredicate instanceof AndJanusPredicate) {
                if (QueryUtil.addConstraint(type, (AndJanusPredicate)janusGraphPredicate, (List<Object>)((List)values.get(i)), and, tx) != null) continue;
                return null;
            }
            if (predicate.get(i) instanceof OrJanusPredicate) {
                List childValues = (List)values.get(i);
                Or nested = QueryUtil.addConstraint(type, (OrJanusPredicate)janusGraphPredicate, (List<Object>)childValues, new Or(childValues.size()), tx);
                if (nested == null) {
                    return null;
                }
                and.add(nested);
                continue;
            }
            QueryUtil.addConstraint(type, janusGraphPredicate, values.get(i), and, tx);
        }
        return and;
    }

    private static <E extends JanusGraphElement> Or<E> addConstraint(RelationType type, OrJanusPredicate predicate, List<Object> values, Or<E> or, StandardJanusGraphTx tx) {
        for (int i = 0; i < values.size(); ++i) {
            JanusGraphPredicate janusGraphPredicate = (JanusGraphPredicate)predicate.get(i);
            if (janusGraphPredicate instanceof AndJanusPredicate) {
                List childValues = (List)values.get(i);
                And nested = QueryUtil.addConstraint(type, (AndJanusPredicate)janusGraphPredicate, (List<Object>)childValues, new And(childValues.size()), tx);
                if (nested == null) {
                    return null;
                }
                or.add(nested);
                continue;
            }
            if (janusGraphPredicate instanceof OrJanusPredicate) {
                if (QueryUtil.addConstraint(type, (OrJanusPredicate)janusGraphPredicate, (List<Object>)((List)values.get(i)), or, tx) != null) continue;
                return null;
            }
            QueryUtil.addConstraint(type, janusGraphPredicate, values.get(i), or, tx);
        }
        return or;
    }

    private static <E extends JanusGraphElement> void addConstraint(RelationType type, JanusGraphPredicate predicate, Object value, MultiCondition<E> conditions, StandardJanusGraphTx tx) {
        PredicateCondition pc;
        if (type.isPropertyKey()) {
            if (value != null) {
                value = tx.verifyAttribute((PropertyKey)type, value);
            }
        } else {
            Preconditions.checkArgument((boolean)(value instanceof JanusGraphVertex));
        }
        if (!conditions.contains(pc = new PredicateCondition(type, predicate, value))) {
            conditions.add(pc);
        }
    }

    public static Map.Entry<RelationType, Collection> extractOrCondition(Or<JanusGraphRelation> condition) {
        RelationType masterType = null;
        ArrayList<Object> values = new ArrayList<Object>();
        for (Condition c : condition.getChildren()) {
            if (!(c instanceof PredicateCondition)) {
                return null;
            }
            PredicateCondition atom = (PredicateCondition)c;
            if (atom.getPredicate() != Cmp.EQUAL) {
                return null;
            }
            Object value = atom.getValue();
            if (value == null) {
                return null;
            }
            RelationType type = (RelationType)atom.getKey();
            if (masterType == null) {
                masterType = type;
            } else if (!masterType.equals(type)) {
                return null;
            }
            values.add(value);
        }
        if (masterType == null) {
            return null;
        }
        assert (!values.isEmpty());
        return new AbstractMap.SimpleImmutableEntry(masterType, values);
    }

    public static <R> List<R> processIntersectingRetrievals(List<IndexCall<R>> retrievals, int limit) {
        boolean exhaustedResults;
        ArrayList results;
        Preconditions.checkArgument((!retrievals.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"Invalid limit: %s", (Object[])new Object[]{limit});
        int multiplier = Math.min(16, (int)Math.pow(2.0, retrievals.size() - 1));
        int subLimit = Integer.MAX_VALUE;
        if (Integer.MAX_VALUE / multiplier >= limit) {
            subLimit = limit * multiplier;
        }
        do {
            exhaustedResults = true;
            results = null;
            for (IndexCall<R> call : retrievals) {
                Collection<R> subResult;
                try {
                    subResult = call.call(subLimit);
                }
                catch (Exception e) {
                    throw new JanusGraphException("Could not process individual retrieval call ", e);
                }
                if (subResult.size() >= subLimit) {
                    exhaustedResults = false;
                }
                if (results == null) {
                    results = Lists.newArrayList(subResult);
                    continue;
                }
                ImmutableSet subResultSet = ImmutableSet.copyOf(subResult);
                results.removeIf(arg_0 -> QueryUtil.lambda$processIntersectingRetrievals$0((Set)subResultSet, arg_0));
            }
            subLimit = (int)Math.min(2.147483646E9, Math.max(Math.pow(subLimit, 1.5), (double)((subLimit + 1) * 2)));
        } while (results != null && results.size() < limit && !exhaustedResults);
        return results;
    }

    private static /* synthetic */ boolean lambda$processIntersectingRetrievals$0(Set subResultSet, Object o) {
        return !subResultSet.contains(o);
    }

    public static interface IndexCall<R> {
        public Collection<R> call(int var1);
    }
}

