/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.relations.RelationIdentifier;

public class ElementUtils {
    public static long getVertexId(Object id) {
        if (null == id) {
            return 0L;
        }
        if (id instanceof JanusGraphVertex) {
            return ((JanusGraphVertex)id).longId();
        }
        if (id instanceof Long) {
            return (Long)id;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue();
        }
        try {
            if (id instanceof Vertex) {
                return Long.parseLong(((Vertex)id).id().toString());
            }
            return Long.valueOf(id.toString());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static RelationIdentifier getEdgeId(Object id) {
        if (null == id) {
            return null;
        }
        try {
            if (id instanceof JanusGraphEdge) {
                return (RelationIdentifier)((JanusGraphEdge)id).id();
            }
            if (id instanceof RelationIdentifier) {
                return (RelationIdentifier)id;
            }
            if (id instanceof String) {
                return RelationIdentifier.parse((String)id);
            }
            if (id instanceof long[]) {
                return RelationIdentifier.get((long[])id);
            }
            if (id instanceof int[]) {
                return RelationIdentifier.get((int[])id);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public static void verifyArgsMustBeEitherIdOrElement(Object ... ids) {
        assert (ids.length > 0);
        int numElements = 0;
        for (Object id : ids) {
            if (!(id instanceof Element)) continue;
            ++numElements;
        }
        if (numElements > 0 && numElements < ids.length) {
            throw Graph.Exceptions.idArgsMustBeEitherIdOrElement();
        }
    }
}

