/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.olap.computer.FulgoraGraphComputer;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsTransaction;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistry;
import org.janusgraph.graphdb.tinkerpop.JanusGraphIoRegistryV1d0;
import org.janusgraph.graphdb.tinkerpop.JanusGraphVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphBlueprintsGraph
implements JanusGraph {
    private static final Logger log = LoggerFactory.getLogger(JanusGraphBlueprintsGraph.class);
    final GraphTransaction tinkerpopTxContainer = new GraphTransaction();
    private ThreadLocal<JanusGraphBlueprintsTransaction> txs = ThreadLocal.withInitial(() -> null);

    public abstract JanusGraphTransaction newThreadBoundTransaction();

    private JanusGraphBlueprintsTransaction getAutoStartTx() {
        if (this.txs == null) {
            throw new IllegalStateException("Graph has been closed");
        }
        this.tinkerpopTxContainer.readWrite();
        JanusGraphBlueprintsTransaction tx = this.txs.get();
        Preconditions.checkState((tx != null ? 1 : 0) != 0, (Object)"Invalid read-write behavior configured: Should either open transaction or throw exception.");
        return tx;
    }

    private void startNewTx() {
        JanusGraphBlueprintsTransaction tx = this.txs.get();
        if (tx != null && tx.isOpen()) {
            throw Transaction.Exceptions.transactionAlreadyOpen();
        }
        tx = (JanusGraphBlueprintsTransaction)this.newThreadBoundTransaction();
        this.txs.set(tx);
        log.debug("Created new thread-bound transaction {}", (Object)tx);
    }

    public JanusGraphTransaction getCurrentThreadTx() {
        return this.getAutoStartTx();
    }

    @Override
    public synchronized void close() {
        this.txs.remove();
        this.txs = null;
    }

    public Transaction tx() {
        return this.tinkerpopTxContainer;
    }

    public String toString() {
        GraphDatabaseConfiguration config = ((StandardJanusGraph)this).getConfiguration();
        return StringFactory.graphString((Graph)this, (String)config.getBackendDescription());
    }

    public Graph.Variables variables() {
        return new JanusGraphVariables(((StandardJanusGraph)this).getBackend().getUserConfiguration());
    }

    public Configuration configuration() {
        GraphDatabaseConfiguration config = ((StandardJanusGraph)this).getConfiguration();
        return config.getConfigurationAtOpen();
    }

    public <I extends Io> I io(Io.Builder<I> builder) {
        if (builder.requiresVersion((Object)GryoVersion.V1_0) || builder.requiresVersion((Object)GraphSONVersion.V1_0)) {
            return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)JanusGraphIoRegistryV1d0.getInstance())).create();
        }
        if (builder.requiresVersion((Object)GraphSONVersion.V2_0)) {
            return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)JanusGraphIoRegistry.getInstance())).create();
        }
        return (I)builder.graph((Graph)this).onMapper(mapper -> mapper.addRegistry((IoRegistry)JanusGraphIoRegistry.getInstance())).create();
    }

    @Override
    public JanusGraphVertex addVertex(Object ... keyValues) {
        return this.getAutoStartTx().addVertex(keyValues);
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return this.getAutoStartTx().vertices(vertexIds);
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        return this.getAutoStartTx().edges(edgeIds);
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        if (!graphComputerClass.equals(FulgoraGraphComputer.class)) {
            throw Graph.Exceptions.graphDoesNotSupportProvidedGraphComputer(graphComputerClass);
        }
        return (C)this.compute();
    }

    public FulgoraGraphComputer compute() throws IllegalArgumentException {
        StandardJanusGraph graph = (StandardJanusGraph)this;
        return new FulgoraGraphComputer(graph, graph.getConfiguration().getConfiguration());
    }

    @Override
    public JanusGraphVertex addVertex(String vertexLabel) {
        return this.getAutoStartTx().addVertex(vertexLabel);
    }

    @Override
    public JanusGraphQuery<? extends JanusGraphQuery> query() {
        return this.getAutoStartTx().query();
    }

    @Override
    public JanusGraphIndexQuery indexQuery(String indexName, String query) {
        return this.getAutoStartTx().indexQuery(indexName, query);
    }

    @Deprecated
    public JanusGraphMultiVertexQuery multiQuery(JanusGraphVertex ... vertices) {
        return this.getAutoStartTx().multiQuery(vertices);
    }

    @Deprecated
    public JanusGraphMultiVertexQuery multiQuery(Collection<JanusGraphVertex> vertices) {
        return this.getAutoStartTx().multiQuery(vertices);
    }

    @Override
    public PropertyKeyMaker makePropertyKey(String name) {
        return this.getAutoStartTx().makePropertyKey(name);
    }

    @Override
    public EdgeLabelMaker makeEdgeLabel(String name) {
        return this.getAutoStartTx().makeEdgeLabel(name);
    }

    @Override
    public VertexLabelMaker makeVertexLabel(String name) {
        return this.getAutoStartTx().makeVertexLabel(name);
    }

    @Override
    public VertexLabel addProperties(VertexLabel vertexLabel, PropertyKey ... keys) {
        return this.getAutoStartTx().addProperties(vertexLabel, keys);
    }

    @Override
    public EdgeLabel addProperties(EdgeLabel edgeLabel, PropertyKey ... keys) {
        return this.getAutoStartTx().addProperties(edgeLabel, keys);
    }

    @Override
    public EdgeLabel addConnection(EdgeLabel edgeLabel, VertexLabel outVLabel, VertexLabel inVLabel) {
        return this.getAutoStartTx().addConnection(edgeLabel, outVLabel, inVLabel);
    }

    @Override
    public boolean containsPropertyKey(String name) {
        return this.getAutoStartTx().containsPropertyKey(name);
    }

    @Override
    public PropertyKey getOrCreatePropertyKey(String name) {
        return this.getAutoStartTx().getOrCreatePropertyKey(name);
    }

    @Override
    public PropertyKey getPropertyKey(String name) {
        return this.getAutoStartTx().getPropertyKey(name);
    }

    @Override
    public boolean containsEdgeLabel(String name) {
        return this.getAutoStartTx().containsEdgeLabel(name);
    }

    @Override
    public EdgeLabel getOrCreateEdgeLabel(String name) {
        return this.getAutoStartTx().getOrCreateEdgeLabel(name);
    }

    @Override
    public EdgeLabel getEdgeLabel(String name) {
        return this.getAutoStartTx().getEdgeLabel(name);
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.getAutoStartTx().containsRelationType(name);
    }

    @Override
    public RelationType getRelationType(String name) {
        return this.getAutoStartTx().getRelationType(name);
    }

    @Override
    public boolean containsVertexLabel(String name) {
        return this.getAutoStartTx().containsVertexLabel(name);
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        return this.getAutoStartTx().getVertexLabel(name);
    }

    @Override
    public VertexLabel getOrCreateVertexLabel(String name) {
        return this.getAutoStartTx().getOrCreateVertexLabel(name);
    }

    class GraphTransaction
    extends AbstractThreadLocalTransaction {
        public GraphTransaction() {
            super((Graph)JanusGraphBlueprintsGraph.this);
        }

        public void doOpen() {
            JanusGraphBlueprintsGraph.this.startNewTx();
        }

        public void doCommit() {
            JanusGraphBlueprintsGraph.this.getAutoStartTx().commit();
        }

        public void doRollback() {
            JanusGraphBlueprintsGraph.this.getAutoStartTx().rollback();
        }

        public JanusGraphTransaction createThreadedTx() {
            return JanusGraphBlueprintsGraph.this.newTransaction();
        }

        public boolean isOpen() {
            if (null == JanusGraphBlueprintsGraph.this.txs) {
                return false;
            }
            JanusGraphBlueprintsTransaction tx = (JanusGraphBlueprintsTransaction)JanusGraphBlueprintsGraph.this.txs.get();
            return tx != null && tx.isOpen();
        }

        protected void doClose() {
            super.doClose();
            this.transactionListeners.remove();
            JanusGraphBlueprintsGraph.this.txs.remove();
        }

        public Transaction onReadWrite(Consumer<Transaction> transactionConsumer) {
            Preconditions.checkArgument((boolean)(transactionConsumer instanceof Transaction.READ_WRITE_BEHAVIOR), (String)"Only READ_WRITE_BEHAVIOR instances are accepted argument, got: %s", (Object[])new Object[]{transactionConsumer});
            return super.onReadWrite(transactionConsumer);
        }

        public Transaction onClose(Consumer<Transaction> transactionConsumer) {
            Preconditions.checkArgument((boolean)(transactionConsumer instanceof Transaction.CLOSE_BEHAVIOR), (String)"Only CLOSE_BEHAVIOR instances are accepted argument, got: %s", (Object[])new Object[]{transactionConsumer});
            return super.onClose(transactionConsumer);
        }
    }
}

