/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.janusgraph.core.PropertyKey;

public class IndexField {
    private final PropertyKey key;

    IndexField(PropertyKey key) {
        Preconditions.checkNotNull((Object)key);
        this.key = key;
    }

    public PropertyKey getFieldKey() {
        return this.key;
    }

    public static IndexField of(PropertyKey key) {
        return new IndexField(key);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key});
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null || !this.getClass().isInstance(oth)) {
            return false;
        }
        IndexField other = (IndexField)oth;
        if (this.key == null) {
            return this.key == other.key;
        }
        return this.key.equals(other.key);
    }

    public String toString() {
        return "[" + this.key.name() + "]";
    }
}

