/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.datastructures;

import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.janusgraph.util.datastructures.Interval;
import org.janusgraph.util.datastructures.PointInterval;

public class RangeInterval<T>
implements Interval<T> {
    private boolean startInclusive = true;
    private boolean endInclusive = true;
    private T start = null;
    private T end = null;

    public RangeInterval() {
    }

    public RangeInterval(T start, T end) {
        this.setStart(start, true);
        this.setEnd(end, true);
    }

    public RangeInterval<T> setStart(T start, boolean inclusive) {
        Preconditions.checkArgument((boolean)(start instanceof Comparable));
        this.start = start;
        this.setStartInclusive(inclusive);
        return this;
    }

    public RangeInterval<T> setEnd(T end, boolean inclusive) {
        Preconditions.checkArgument((boolean)(end instanceof Comparable));
        this.end = end;
        this.setEndInclusive(inclusive);
        return this;
    }

    public RangeInterval<T> setStartInclusive(boolean inclusive) {
        Preconditions.checkArgument((this.start == null || this.start instanceof Comparable ? 1 : 0) != 0);
        this.startInclusive = inclusive;
        return this;
    }

    public RangeInterval<T> setEndInclusive(boolean inclusive) {
        Preconditions.checkArgument((this.end == null || this.end instanceof Comparable ? 1 : 0) != 0);
        this.endInclusive = inclusive;
        return this;
    }

    @Override
    public T getStart() {
        return this.start;
    }

    @Override
    public T getEnd() {
        return this.end;
    }

    @Override
    public boolean startInclusive() {
        return this.startInclusive;
    }

    @Override
    public boolean endInclusive() {
        return this.endInclusive;
    }

    @Override
    public boolean isPoints() {
        return this.start != null && this.end != null && this.start.equals(this.end) && this.startInclusive && this.endInclusive;
    }

    @Override
    public Collection<T> getPoints() {
        HashSet<T> set = new HashSet<T>(2);
        if (this.start != null) {
            set.add(this.start);
        }
        if (this.end != null) {
            set.add(this.end);
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        if (this.start == null || this.end == null) {
            return false;
        }
        if (this.isPoints()) {
            return false;
        }
        int cmp = ((Comparable)this.start).compareTo(this.end);
        return cmp > 0 || cmp == 0 && (!this.startInclusive || !this.endInclusive);
    }

    @Override
    public Interval<T> intersect(Interval<T> other) {
        Preconditions.checkArgument((other != null ? 1 : 0) != 0);
        if (other instanceof PointInterval) {
            return other.intersect(this);
        }
        if (other instanceof RangeInterval) {
            RangeInterval rint = (RangeInterval)other;
            Map.Entry<T, Boolean> newStart = this.comparePoints(this.start, this.startInclusive, rint.start, rint.startInclusive, true);
            Map.Entry<T, Boolean> newEnd = this.comparePoints(this.end, this.endInclusive, rint.end, rint.endInclusive, false);
            RangeInterval<T> result = new RangeInterval<T>(newStart.getKey(), newEnd.getKey());
            result.setStartInclusive(newStart.getValue());
            result.setEndInclusive(newEnd.getValue());
            return result;
        }
        throw new AssertionError((Object)("Unexpected interval: " + other));
    }

    private Map.Entry<T, Boolean> comparePoints(T one, boolean oneIncl, T two, boolean twoIncl, boolean chooseBigger) {
        if (one == null) {
            return new AbstractMap.SimpleImmutableEntry<T, Boolean>(two, twoIncl);
        }
        if (two == null) {
            return new AbstractMap.SimpleImmutableEntry<T, Boolean>(one, oneIncl);
        }
        int c = ((Comparable)one).compareTo(two);
        if (c == 0) {
            return new AbstractMap.SimpleImmutableEntry<T, Boolean>(one, oneIncl & twoIncl);
        }
        if (c > 0 && chooseBigger || c < 0 && !chooseBigger) {
            return new AbstractMap.SimpleImmutableEntry<T, Boolean>(one, oneIncl);
        }
        return new AbstractMap.SimpleImmutableEntry<T, Boolean>(two, twoIncl);
    }

    public boolean containsPoint(T other) {
        int cmp;
        Preconditions.checkNotNull(other);
        if (this.isPoints()) {
            return this.start.equals(other);
        }
        if (this.start != null && ((cmp = ((Comparable)this.start).compareTo(other)) > 0 || cmp == 0 && !this.startInclusive)) {
            return false;
        }
        if (this.end != null) {
            cmp = ((Comparable)this.end).compareTo(other);
            return cmp >= 0 && (cmp != 0 || this.endInclusive);
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.startInclusive, this.endInclusive);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        RangeInterval oth = (RangeInterval)other;
        return Objects.equals(this.start, oth.start) && Objects.equals(this.end, oth.end) && this.end.equals(oth.end) && this.endInclusive == oth.endInclusive && this.startInclusive == oth.startInclusive;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.startInclusive) {
            b.append("[");
        } else {
            b.append("(");
        }
        b.append(this.start).append(",").append(this.end);
        if (this.endInclusive) {
            b.append("]");
        } else {
            b.append(")");
        }
        return b.toString();
    }
}

