/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.util.Map;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.stereotype.Component;

@Component(value="queryAndEncodeDatabaseAuthenticationHandler")
public class QueryAndEncodeDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    private static final String DEFAULT_PASSWORD_FIELD = "password";
    private static final String DEFAULT_SALT_FIELD = "salt";
    private static final String DEFAULT_NUM_ITERATIONS_FIELD = "numIterations";
    @NotNull
    protected String algorithmName;
    @NotNull
    protected String sql;
    @NotNull
    protected String passwordFieldName = "password";
    @NotNull
    protected String saltFieldName = "salt";
    @NotNull
    protected String numberOfIterationsFieldName = "numIterations";
    protected long numberOfIterations;
    protected String staticSalt;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential transformedCredential) throws GeneralSecurityException, PreventedException {
        if (StringUtils.isBlank((CharSequence)this.sql) || StringUtils.isBlank((CharSequence)this.algorithmName) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly");
        }
        String username = this.getPrincipalNameTransformer().transform(transformedCredential.getUsername());
        String encodedPsw = this.getPasswordEncoder().encode(transformedCredential.getPassword());
        try {
            Map values = this.getJdbcTemplate().queryForMap(this.sql, new Object[]{username});
            String digestedPassword = this.digestEncodedPassword(encodedPsw, values);
            if (!values.get(this.passwordFieldName).equals(digestedPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
            return this.createHandlerResult((Credential)transformedCredential, this.principalFactory.createPrincipal(username), null);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(String.valueOf(username) + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
    }

    protected String digestEncodedPassword(String encodedPassword, Map<String, Object> values) {
        DefaultHashService hashService = new DefaultHashService();
        if (StringUtils.isNotBlank((CharSequence)this.staticSalt)) {
            hashService.setPrivateSalt(ByteSource.Util.bytes((String)this.staticSalt));
        }
        hashService.setHashAlgorithmName(this.algorithmName);
        Long numOfIterations = this.numberOfIterations;
        if (values.containsKey(this.numberOfIterationsFieldName)) {
            String longAsStr = values.get(this.numberOfIterationsFieldName).toString();
            numOfIterations = Long.valueOf(longAsStr);
        }
        hashService.setHashIterations(numOfIterations.intValue());
        if (!values.containsKey(this.saltFieldName)) {
            throw new RuntimeException("Specified field name for salt does not exist in the results");
        }
        String dynaSalt = values.get(this.saltFieldName).toString();
        HashRequest request = new HashRequest.Builder().setSalt((Object)dynaSalt).setSource((Object)encodedPassword).build();
        return hashService.computeHash(request).toHex();
    }

    @Autowired
    public void setAlgorithmName(@Value(value="${cas.jdbc.authn.query.encode.alg:}") String algorithmName) {
        this.algorithmName = algorithmName;
    }

    @Autowired
    public void setSql(@Value(value="${cas.jdbc.authn.query.encode.sql:}") String sql) {
        this.sql = sql;
    }

    @Autowired
    public final void setStaticSalt(@Value(value="${cas.jdbc.authn.query.encode.salt.static:}") String staticSalt) {
        this.staticSalt = staticSalt;
    }

    @Autowired
    public final void setPasswordFieldName(@Value(value="${cas.jdbc.authn.query.encode.password:password}") String passwordFieldName) {
        this.passwordFieldName = passwordFieldName;
    }

    @Autowired
    public final void setSaltFieldName(@Value(value="${cas.jdbc.authn.query.encode.salt:salt}") String saltFieldName) {
        this.saltFieldName = saltFieldName;
    }

    @Autowired
    public final void setNumberOfIterationsFieldName(@Value(value="${cas.jdbc.authn.query.encode.iterations.field:numIterations}") String numberOfIterationsFieldName) {
        this.numberOfIterationsFieldName = numberOfIterationsFieldName;
    }

    @Autowired
    public final void setNumberOfIterations(@Value(value="${cas.jdbc.authn.query.encode.iterations:0}") long numberOfIterations) {
        this.numberOfIterations = numberOfIterations;
    }

    @Override
    @Autowired(required=false)
    public void setDataSource(@Qualifier(value="queryEncodeDatabaseDataSource") DataSource dataSource) {
        super.setDataSource(dataSource);
    }
}

