/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import javax.annotation.PostConstruct;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component(value="searchModeSearchDatabaseAuthenticationHandler")
public class SearchModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler
implements InitializingBean {
    private static final String SQL_PREFIX = "Select count('x') from ";
    @NotNull
    private String fieldUser;
    @NotNull
    private String fieldPassword;
    @NotNull
    private String tableUsers;
    private String sql;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        int count;
        if (StringUtils.isBlank((CharSequence)this.sql) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly");
        }
        String username = credential.getUsername();
        String encyptedPassword = this.getPasswordEncoder().encode(credential.getPassword());
        try {
            count = (Integer)this.getJdbcTemplate().queryForObject(this.sql, Integer.class, new Object[]{username, encyptedPassword});
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
        if (count == 0) {
            throw new FailedLoginException(String.valueOf(username) + " not found with SQL query.");
        }
        return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (StringUtils.isNotBlank((CharSequence)this.tableUsers) || StringUtils.isNotBlank((CharSequence)this.fieldUser) || StringUtils.isNotBlank((CharSequence)this.fieldPassword)) {
            this.sql = SQL_PREFIX + this.tableUsers + " WHERE " + this.fieldUser + " = ? AND " + this.fieldPassword + " = ?";
        }
    }

    @Autowired
    public final void setFieldPassword(@Value(value="${cas.jdbc.authn.search.password:}") String fieldPassword) {
        this.fieldPassword = fieldPassword;
    }

    @Autowired
    public final void setFieldUser(@Value(value="${cas.jdbc.authn.search.user:}") String fieldUser) {
        this.fieldUser = fieldUser;
    }

    @Autowired
    public final void setTableUsers(@Value(value="${cas.jdbc.authn.search.table:}") String tableUsers) {
        this.tableUsers = tableUsers;
    }

    @Override
    @Autowired(required=false)
    public void setDataSource(@Qualifier(value="searchModeDatabaseDataSource") DataSource dataSource) {
        super.setDataSource(dataSource);
    }
}

