/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.ldap.remote.RemoteAddressCredentials;
import org.jasig.cas.authentication.principal.AbstractLdapPersonDirectoryCredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.util.StringUtils;

public final class RemoteIpLookupCredentialsToPrincipalResolver
extends AbstractLdapPersonDirectoryCredentialsToPrincipalResolver {
    private static final String ADDR_STANDARD = "standard";
    private static final String ADDR_EDIR87 = "edirectory87";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private String ipAddressFormat = "standard";

    protected String extractPrincipalId(Credentials credentials) {
        RemoteAddressCredentials c = (RemoteAddressCredentials)credentials;
        String formattedIpAddress = this.getFormattedIpAddress(c.getRemoteAddress().trim());
        if (!StringUtils.hasText((String)formattedIpAddress)) {
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Original IP address: " + c.getRemoteAddress());
            this.log.debug("Formatted IP address: " + formattedIpAddress);
        }
        final String attributeId = this.getAttributeIds()[0];
        List principalList = this.getLdapTemplate().search(this.getSearchBase(), LdapUtils.getFilterWithValues(this.getFilter(), formattedIpAddress), this.getSearchControls(), new AttributesMapper(){

            public Object mapFromAttributes(Attributes attrs) throws NamingException {
                Attribute attribute = attrs.get(attributeId);
                return attribute == null ? null : attribute.get();
            }
        });
        if (principalList.isEmpty()) {
            this.log.debug("LDAP search returned zero results.");
            return null;
        }
        if (principalList.size() > 1) {
            this.log.error("LDAP search returned multiple results for filter \"" + this.getFilter() + "\", " + "which is not allowed.");
            return null;
        }
        return (String)principalList.get(0);
    }

    public boolean supports(Credentials credentials) {
        return credentials.getClass().equals(RemoteAddressCredentials.class);
    }

    private String getFormattedIpAddress(String remoteAddress) {
        try {
            String formattedAddress = InetAddress.getByName(remoteAddress).getHostAddress();
            if (this.ipAddressFormat.compareTo(ADDR_EDIR87) == 0) {
                String networkAddress = "\\31\\23";
                String[] octets = formattedAddress.replace('.', '_').split("_");
                int i = 0;
                while (i < octets.length) {
                    String octet = octets[i];
                    networkAddress = String.valueOf(networkAddress) + "\\" + this.getHexadecimal(octet);
                    ++i;
                }
                return networkAddress;
            }
            return formattedAddress;
        }
        catch (UnknownHostException e) {
            this.log.error(e.toString(), (Throwable)e);
            return null;
        }
    }

    private String getHexadecimal(String octet) {
        int ipOctet = Integer.parseInt(octet);
        String hex = Integer.toString(ipOctet, 16);
        while (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public void setIpAddressFormat(String ipAddressFormat) {
        this.ipAddressFormat = ipAddressFormat;
    }
}

