/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import javax.naming.directory.DirContext;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.AbstractNamedMonitor;
import org.jasig.cas.monitor.Status;
import org.jasig.cas.util.LdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.pool.DirContextType;
import org.springframework.ldap.pool.validation.DirContextValidator;

public class ContextSourceMonitor
extends AbstractNamedMonitor<Status> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private final LdapContextSource contextSource;
    @NotNull
    private final DirContextValidator dirContextValidator;

    public ContextSourceMonitor(LdapContextSource source, DirContextValidator validator) {
        this.contextSource = source;
        this.dirContextValidator = validator;
    }

    public Status observe() {
        DirContext context;
        try {
            context = this.contextSource.getReadOnlyContext();
        }
        catch (Exception e) {
            this.logger.error("Error getting LDAP connection to monitor", (Throwable)e);
            return Status.ERROR;
        }
        try {
            Status status = this.dirContextValidator.validateDirContext(DirContextType.READ_ONLY, context) ? Status.OK : Status.ERROR;
            return status;
        }
        finally {
            LdapUtils.closeContext(context);
        }
    }
}

