/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import org.jasig.cas.monitor.AbstractPoolMonitor;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.util.LdapUtils;
import org.ldaptive.Connection;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.Validator;

public class PooledConnectionFactoryMonitor
extends AbstractPoolMonitor {
    private final PooledConnectionFactory connectionFactory;
    private final Validator<Connection> validator;

    public PooledConnectionFactoryMonitor(PooledConnectionFactory factory, Validator<Connection> validator) {
        this.connectionFactory = factory;
        this.validator = validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatusCode checkPool() throws Exception {
        Connection conn = this.connectionFactory.getConnection();
        try {
            StatusCode statusCode = this.validator.validate((Object)conn) ? StatusCode.OK : StatusCode.ERROR;
            return statusCode;
        }
        finally {
            LdapUtils.closeConnection(conn);
        }
    }

    protected int getIdleCount() {
        return this.connectionFactory.getConnectionPool().availableCount();
    }

    protected int getActiveCount() {
        return this.connectionFactory.getConnectionPool().activeCount();
    }
}

