/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.ldaptive.Connection;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapUtils {
    public static final String OBJECTCLASS_ATTRIBUTE = "objectClass";
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUtils.class);

    private LdapUtils() {
    }

    public static void closeConnection(Connection context) {
        if (context != null && context.isOpen()) {
            try {
                context.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Could not close ldap connection", (Throwable)ex);
            }
        }
    }

    public static Boolean getBoolean(LdapEntry ctx, String attribute) {
        return LdapUtils.getBoolean(ctx, attribute, Boolean.FALSE);
    }

    public static Boolean getBoolean(LdapEntry ctx, String attribute, Boolean nullValue) {
        String v = LdapUtils.getString(ctx, attribute, nullValue.toString());
        if (v != null) {
            return v.equalsIgnoreCase(Boolean.TRUE.toString());
        }
        return nullValue;
    }

    public static Long getLong(LdapEntry ctx, String attribute) {
        return LdapUtils.getLong(ctx, attribute, Long.MIN_VALUE);
    }

    public static Long getLong(LdapEntry entry, String attribute, Long nullValue) {
        String v = LdapUtils.getString(entry, attribute, nullValue.toString());
        if (v != null && NumberUtils.isNumber((String)v)) {
            return Long.valueOf(v);
        }
        return nullValue;
    }

    public static String getString(LdapEntry entry, String attribute) {
        return LdapUtils.getString(entry, attribute, null);
    }

    public static String getString(LdapEntry entry, String attribute, String nullValue) {
        LdapAttribute attr = entry.getAttribute(attribute);
        if (attr == null) {
            return nullValue;
        }
        String v = null;
        if (attr.isBinary()) {
            byte[] b = attr.getBinaryValue();
            v = new String(b, Charset.forName("UTF-8"));
        } else {
            v = attr.getStringValue();
        }
        if (StringUtils.isNotBlank((CharSequence)v)) {
            return v;
        }
        return nullValue;
    }
}

