/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;

public class LdapAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String LDAP_ATTRIBUTE_ENTRY_DN = LdapAuthenticationHandler.class.getSimpleName().concat(".dn");
    @NotNull
    protected Map<String, String> principalAttributeMap = Collections.emptyMap();
    @NotNull
    protected List<String> additionalAttributes = Collections.emptyList();
    @NotNull
    private final Authenticator authenticator;
    @NotNull
    private String name = LdapAuthenticationHandler.class.getSimpleName();
    private String principalIdAttribute;
    private boolean allowMultiplePrincipalAttributeValues;
    private String[] authenticatedEntryAttributes = ReturnAttributes.NONE.value();

    public LdapAuthenticationHandler(@NotNull Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrincipalIdAttribute(String attributeName) {
        this.principalIdAttribute = attributeName;
    }

    public void setAllowMultiplePrincipalAttributeValues(boolean allowed) {
        this.allowMultiplePrincipalAttributeValues = allowed;
    }

    public void setPrincipalAttributeMap(Map<String, String> attributeNameMap) {
        this.principalAttributeMap = attributeNameMap;
    }

    public void setPrincipalAttributeList(List<String> attributeList) {
        this.principalAttributeMap = Maps.uniqueIndex(attributeList, (Function)Functions.toStringFunction());
    }

    public void setAdditionalAttributes(List<String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential upc) throws GeneralSecurityException, PreventedException {
        List messageList;
        AuthenticationResponse response;
        try {
            this.logger.debug("Attempting LDAP authentication for {}", (Object)upc);
            String password = this.getPasswordEncoder().encode(upc.getPassword());
            AuthenticationRequest request = new AuthenticationRequest(upc.getUsername(), new org.ldaptive.Credential(password), this.authenticatedEntryAttributes);
            response = this.authenticator.authenticate(request);
        }
        catch (LdapException e) {
            this.logger.trace(e.getMessage(), (Throwable)e);
            throw new PreventedException("Unexpected LDAP error", (Throwable)e);
        }
        this.logger.debug("LDAP response: {}", (Object)response);
        LdapPasswordPolicyConfiguration ldapPasswordPolicyConfiguration = (LdapPasswordPolicyConfiguration)super.getPasswordPolicyConfiguration();
        if (ldapPasswordPolicyConfiguration != null) {
            this.logger.debug("Applying password policy to {}", (Object)response);
            messageList = ldapPasswordPolicyConfiguration.getAccountStateHandler().handle(response, ldapPasswordPolicyConfiguration);
        } else {
            this.logger.debug("No ldap password policy configuration is defined");
            messageList = Collections.emptyList();
        }
        if (((Boolean)response.getResult()).booleanValue()) {
            this.logger.debug("LDAP response returned as result. Creating the final LDAP principal");
            return this.createHandlerResult((Credential)upc, this.createPrincipal(upc.getUsername(), response.getLdapEntry()), messageList);
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode()) {
            this.logger.warn("DN resolution failed. {}", (Object)response.getMessage());
            throw new AccountNotFoundException(String.valueOf(upc.getUsername()) + " not found.");
        }
        throw new FailedLoginException("Invalid credentials");
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    public String getName() {
        return this.name;
    }

    protected Principal createPrincipal(String username, LdapEntry ldapEntry) throws LoginException {
        String id;
        this.logger.debug("Creating LDAP principal for {} based on {}", (Object)username, (Object)ldapEntry.getDn());
        if (this.principalIdAttribute != null) {
            LdapAttribute principalAttr = ldapEntry.getAttribute(this.principalIdAttribute);
            if (principalAttr == null || principalAttr.size() == 0) {
                this.logger.error("The principal id attribute {} is not found. CAS cannot construct the final authenticated principal if it's unable to locate the attribute that is designated as the principal id. Attributes available are {}", (Object)this.principalIdAttribute, (Object)ldapEntry.getAttributes());
                throw new LoginException(String.valueOf(this.principalIdAttribute) + " attribute not found for " + username);
            }
            if (principalAttr.size() > 1) {
                if (this.allowMultiplePrincipalAttributeValues) {
                    this.logger.warn("Found multiple values for principal ID attribute: {}. Using first value={}.", (Object)principalAttr, (Object)principalAttr.getStringValue());
                } else {
                    throw new LoginException("Multiple principal values not allowed: " + principalAttr);
                }
            }
            id = principalAttr.getStringValue();
            this.logger.debug("Retrieved principal id attribute {}", (Object)id);
        } else {
            id = username;
            this.logger.debug("Principal id attribute is not defined. Using the default id {}", (Object)id);
        }
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(this.principalAttributeMap.size());
        for (Map.Entry<String, String> ldapAttr : this.principalAttributeMap.entrySet()) {
            LdapAttribute attr = ldapEntry.getAttribute(ldapAttr.getKey());
            if (attr == null) continue;
            this.logger.debug("Found principal attribute: {}", (Object)attr);
            String principalAttrName = ldapAttr.getValue();
            if (attr.size() > 1) {
                this.logger.debug("Principal attribute: {} is multivalued", (Object)attr);
                attributeMap.put(principalAttrName, attr.getStringValues());
                continue;
            }
            attributeMap.put(principalAttrName, attr.getStringValue());
        }
        attributeMap.put(LDAP_ATTRIBUTE_ENTRY_DN, ldapEntry.getDn());
        this.logger.debug("Created LDAP principal for id {} and {} attributes", (Object)id, (Object)attributeMap.size());
        return this.principalFactory.createPrincipal(id, attributeMap);
    }

    @PostConstruct
    public void initialize() {
        HashSet<String> attributes = new HashSet<String>();
        this.logger.debug("Initializing LDAP attribute configuration.");
        if (this.principalIdAttribute != null) {
            this.logger.debug("Configured to retrieve principal id attribute {}", (Object)this.principalIdAttribute);
            attributes.add(this.principalIdAttribute);
        }
        if (!this.principalAttributeMap.isEmpty()) {
            Set<String> attrs = this.principalAttributeMap.keySet();
            attributes.addAll(attrs);
            this.logger.debug("Configured to retrieve principal attribute collection of {}", attrs);
        }
        if (!this.additionalAttributes.isEmpty()) {
            attributes.addAll(this.additionalAttributes);
            this.logger.debug("Configured to retrieve additional attributes {}", this.additionalAttributes);
        }
        if (!attributes.isEmpty()) {
            this.authenticatedEntryAttributes = attributes.toArray(new String[attributes.size()]);
        }
        this.logger.debug("LDAP authentication entry attributes are {}", (Object[])this.authenticatedEntryAttributes);
    }
}

