/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authorization.generator;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.pac4j.core.authorization.AuthorizationGenerator;
import org.pac4j.core.exception.AccountNotFoundException;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="ldapAuthorizationGenerator")
public class LdapAuthorizationGenerator
implements AuthorizationGenerator<CommonProfile> {
    public static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    @Autowired(required=false)
    @Qualifier(value="ldapAuthorizationGeneratorConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Nullable
    @Autowired(required=false)
    @Qualifier(value="ldapAuthorizationGeneratorUserSearchExecutor")
    private SearchExecutor userSearchExecutor;
    @Nullable
    @Autowired(required=false)
    @Qualifier(value="ldapAuthorizationGeneratorRoleSearchExecutor")
    private SearchExecutor roleSearchExecutor;
    @NotNull
    @Value(value="${ldap.authorizationgenerator.user.attr:}")
    private String userAttributeName;
    @NotNull
    @Value(value="${ldap.authorizationgenerator.role.attr:}")
    private String roleAttributeName;
    @NotNull
    @Value(value="${ldap.authorizationgenerator.role.prefix:ROLE_}")
    private String rolePrefix = "ROLE_";
    @Value(value="${ldap.authorizationgenerator.allow.multiple:false}")
    private boolean allowMultipleResults;

    public LdapAuthorizationGenerator() {
    }

    public LdapAuthorizationGenerator(ConnectionFactory factory, SearchExecutor userSearchExecutor, SearchExecutor roleSearchExecutor, String userAttributeName, String roleAttributeName) {
        this.connectionFactory = factory;
        this.userSearchExecutor = userSearchExecutor;
        this.roleSearchExecutor = roleSearchExecutor;
        this.userAttributeName = userAttributeName;
        this.roleAttributeName = roleAttributeName;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setAllowMultipleResults(boolean allowMultiple) {
        this.allowMultipleResults = allowMultiple;
    }

    public void generate(CommonProfile profile) {
        SearchResult roleResult;
        SearchResult userResult;
        String username = profile.getId();
        try {
            this.logger.debug("Attempting to get details for user {}.", (Object)username);
            Response response = this.userSearchExecutor.search(this.connectionFactory, this.createSearchFilter(this.userSearchExecutor, username));
            this.logger.debug("LDAP user search response: {}", (Object)response);
            userResult = (SearchResult)response.getResult();
        }
        catch (LdapException e) {
            throw new RuntimeException("LDAP error fetching details for user.", e);
        }
        if (userResult.size() == 0) {
            throw new AccountNotFoundException(String.valueOf(username) + " not found.");
        }
        if (userResult.size() > 1 && !this.allowMultipleResults) {
            throw new IllegalStateException("Found multiple results for user which is not allowed (allowMultipleResults=false).");
        }
        LdapEntry userResultEntry = userResult.getEntry();
        String userDn = userResultEntry.getDn();
        LdapAttribute userAttribute = userResultEntry.getAttribute(this.userAttributeName);
        if (userAttribute == null) {
            throw new IllegalStateException(String.valueOf(this.userAttributeName) + " attribute not found in results.");
        }
        try {
            this.logger.debug("Attempting to get roles for user {}.", (Object)userDn);
            Response response = this.roleSearchExecutor.search(this.connectionFactory, this.createSearchFilter(this.roleSearchExecutor, userDn));
            this.logger.debug("LDAP role search response: {}", (Object)response);
            roleResult = (SearchResult)response.getResult();
        }
        catch (LdapException e) {
            throw new RuntimeException("LDAP error fetching roles for user.", e);
        }
        for (LdapEntry entry : roleResult.getEntries()) {
            LdapAttribute roleAttribute = entry.getAttribute(this.roleAttributeName);
            if (roleAttribute == null) {
                this.logger.warn("Role attribute not found on entry {}", (Object)entry);
                continue;
            }
            for (String role : roleAttribute.getStringValues()) {
                profile.addRole(String.valueOf(this.rolePrefix) + role.toUpperCase());
            }
        }
    }

    private SearchFilter createSearchFilter(SearchExecutor executor, String username) {
        SearchFilter filter = new SearchFilter();
        filter.setFilter(executor.getSearchFilter().getFilter());
        filter.setParameter(0, (Object)username);
        this.logger.debug("Constructed LDAP search filter [{}]", (Object)filter.format());
        return filter;
    }
}

