/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.ServiceFactory;
import org.jasig.cas.support.rest.CredentialFactory;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.registry.DefaultTicketRegistrySupport;
import org.jasig.cas.ticket.registry.TicketRegistrySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ticketResourceRestController")
public class TicketsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketsResource.class);
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    @Autowired(required=false)
    private final CredentialFactory credentialFactory = new DefaultCredentialFactory();
    @Autowired
    @Qualifier(value="webApplicationServiceFactory")
    private ServiceFactory webApplicationServiceFactory;
    @Autowired
    @Qualifier(value="defaultTicketRegistrySupport")
    private TicketRegistrySupport ticketRegistrySupport = new DefaultTicketRegistrySupport();
    private final ObjectMapper jacksonObjectMapper = new ObjectMapper();

    /*
     * Unable to fully structure code
     */
    @RequestMapping(value={"/v1/tickets"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public final ResponseEntity<String> createTicketGrantingTicket(@RequestBody MultiValueMap<String, String> requestBody, HttpServletRequest request) throws JsonProcessingException {
        try {
            var3_3 = null;
            var4_8 = null;
            try {
                fmt = new Formatter();
                try {
                    credential = this.credentialFactory.fromRequestBody(requestBody);
                    builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
                    transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{credential});
                    this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
                    authenticationContext = builder.build();
                    tgtId = this.centralAuthenticationService.createTicketGrantingTicket(authenticationContext);
                    ticketReference = new URI(String.valueOf(request.getRequestURL().toString()) + '/' + tgtId.getId());
                    headers = new HttpHeaders();
                    headers.setLocation(ticketReference);
                    headers.setContentType(MediaType.TEXT_HTML);
                    fmt.format("<!DOCTYPE HTML PUBLIC \\\"-//IETF//DTD HTML 2.0//EN\\\"><html><head><title>", new Object[0]);
                    fmt.format("%s %s", new Object[]{HttpStatus.CREATED, HttpStatus.CREATED.getReasonPhrase()}).format("</title></head><body><h1>TGT Created</h1><form action=\"%s", new Object[]{ticketReference.toString()}).format("\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\">", new Object[0]).format("<br><input type=\"submit\" value=\"Submit\"></form></body></html>", new Object[0]);
                    return new ResponseEntity((Object)fmt.toString(), (MultiValueMap)headers, HttpStatus.CREATED);
                }
                catch (Throwable var3_4) {
                    throw var3_4;
                }
                finally {
                    if (fmt != null) {
                        fmt.close();
                    }
                }
            }
            catch (Throwable var4_9) {
                if (var3_3 == null) {
                    var3_3 = var4_9;
                } else if (var3_3 != var4_9) {
                    var3_3.addSuppressed(var4_9);
                }
                throw var3_3;
            }
        }
        catch (AuthenticationException e) {
            authnExceptions = new LinkedList<String>();
            ** for (handlerErrorEntry : e.getHandlerErrors().entrySet())
        }
lbl-1000:
        // 1 sources

        {
            authnExceptions.add(((Class)handlerErrorEntry.getValue()).getSimpleName());
            continue;
        }
lbl43:
        // 1 sources

        errorsMap = new HashMap<String, LinkedList<String>>();
        errorsMap.put("authentication_exceptions", authnExceptions);
        TicketsResource.LOGGER.error(e.getMessage(), (Throwable)e);
        TicketsResource.LOGGER.error(String.format("Caused by: %s", new Object[]{authnExceptions}));
        return new ResponseEntity((Object)this.jacksonObjectMapper.writer().withDefaultPrettyPrinter().writeValueAsString(errorsMap), HttpStatus.UNAUTHORIZED);
        catch (BadRequestException e) {
            TicketsResource.LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        catch (Throwable e) {
            TicketsResource.LOGGER.error(e.getMessage(), e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/v1/tickets/{tgtId:.+}"}, method={RequestMethod.POST}, consumes={"application/x-www-form-urlencoded"})
    public final ResponseEntity<String> createServiceTicket(@RequestBody MultiValueMap<String, String> requestBody, @PathVariable(value="tgtId") String tgtId) {
        try {
            String serviceId = (String)requestBody.getFirst((Object)"service");
            DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
            Service service = this.webApplicationServiceFactory.createService(serviceId);
            AuthenticationContext authenticationContext = builder.collect(this.ticketRegistrySupport.getAuthenticationFrom(tgtId)).build(service);
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(tgtId, service, authenticationContext);
            return new ResponseEntity((Object)serviceTicketId.getId(), HttpStatus.OK);
        }
        catch (InvalidTicketException invalidTicketException) {
            return new ResponseEntity((Object)"TicketGrantingTicket could not be found", HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/v1/tickets/{tgtId:.+}"}, method={RequestMethod.DELETE})
    public final ResponseEntity<String> deleteTicketGrantingTicket(@PathVariable(value="tgtId") String tgtId) {
        this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
        return new ResponseEntity((Object)tgtId, HttpStatus.OK);
    }

    public void setAuthenticationSystemSupport(AuthenticationSystemSupport authenticationSystemSupport) {
        this.authenticationSystemSupport = authenticationSystemSupport;
    }

    public void setWebApplicationServiceFactory(ServiceFactory webApplicationServiceFactory) {
        this.webApplicationServiceFactory = webApplicationServiceFactory;
    }

    public void setTicketRegistrySupport(TicketRegistrySupport ticketRegistrySupport) {
        this.ticketRegistrySupport = ticketRegistrySupport;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public CentralAuthenticationService getCentralAuthenticationService() {
        return this.centralAuthenticationService;
    }

    public AuthenticationSystemSupport getAuthenticationSystemSupport() {
        return this.authenticationSystemSupport;
    }

    public CredentialFactory getCredentialFactory() {
        return this.credentialFactory;
    }

    public ServiceFactory getWebApplicationServiceFactory() {
        return this.webApplicationServiceFactory;
    }

    public TicketRegistrySupport getTicketRegistrySupport() {
        return this.ticketRegistrySupport;
    }

    private static class BadRequestException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 6852720596988243487L;

        BadRequestException(String msg) {
            super(msg);
        }
    }

    private static class DefaultCredentialFactory
    implements CredentialFactory {
        private DefaultCredentialFactory() {
        }

        @Override
        public Credential fromRequestBody(@NotNull MultiValueMap<String, String> requestBody) {
            String username = (String)requestBody.getFirst((Object)"username");
            String password = (String)requestBody.getFirst((Object)"password");
            if (username == null || password == null) {
                throw new BadRequestException("Invalid payload. 'username' and 'password' form fields are required.");
            }
            return new UsernamePasswordCredential((String)requestBody.getFirst((Object)"username"), (String)requestBody.getFirst((Object)"password"));
        }
    }
}

