/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.authentication.principal;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class SamlService
extends AbstractWebApplicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlService.class);
    private static final String CONST_PARAM_SERVICE = "TARGET";
    private static final String CONST_PARAM_TICKET = "SAMLart";
    private static final String CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE = "<AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE = "</AssertionArtifact>";
    private static final String CONST_START_ARTIFACT_XML_TAG = "<samlp:AssertionArtifact>";
    private static final String CONST_END_ARTIFACT_XML_TAG = "</samlp:AssertionArtifact>";
    private String requestId;
    private static final long serialVersionUID = -6867572626767140223L;

    protected SamlService(String id) {
        super(id, id, null);
    }

    protected SamlService(String id, String originalUrl, String artifactId, String requestId) {
        super(id, originalUrl, artifactId);
        this.requestId = requestId;
    }

    public boolean matches(Service service) {
        return true;
    }

    public String getRequestID() {
        return this.requestId;
    }

    public static SamlService createServiceFrom(HttpServletRequest request) {
        String requestId;
        String artifactId;
        String service = request.getParameter(CONST_PARAM_SERVICE);
        String requestBody = SamlService.getRequestBody(request);
        if (!StringUtils.hasText((String)service) && !StringUtils.hasText((String)requestBody)) {
            return null;
        }
        String id = SamlService.cleanupUrl((String)service);
        if (StringUtils.hasText((String)requestBody)) {
            String tagEnd;
            String tagStart;
            if (requestBody.contains(CONST_START_ARTIFACT_XML_TAG)) {
                tagStart = CONST_START_ARTIFACT_XML_TAG;
                tagEnd = CONST_END_ARTIFACT_XML_TAG;
            } else {
                tagStart = CONST_START_ARTIFACT_XML_TAG_NO_NAMESPACE;
                tagEnd = CONST_END_ARTIFACT_XML_TAG_NO_NAMESPACE;
            }
            int startTagLocation = requestBody.indexOf(tagStart);
            int artifactStartLocation = startTagLocation + tagStart.length();
            int endTagLocation = requestBody.indexOf(tagEnd);
            artifactId = requestBody.substring(artifactStartLocation, endTagLocation).trim();
            requestId = SamlService.extractRequestId(requestBody);
        } else {
            artifactId = null;
            requestId = null;
        }
        LOGGER.debug("Attempted to extract Request from HttpServletRequest. Results:");
        LOGGER.debug(String.format("Request Body: %s", requestBody));
        LOGGER.debug(String.format("Extracted ArtifactId: %s", artifactId));
        LOGGER.debug(String.format("Extracted Request Id: %s", requestId));
        return new SamlService(id, service, artifactId, requestId);
    }

    public Response getResponse(String ticketId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(CONST_PARAM_TICKET, ticketId);
        parameters.put(CONST_PARAM_SERVICE, this.getOriginalUrl());
        return Response.getRedirectResponse((String)this.getOriginalUrl(), parameters);
    }

    protected static String extractRequestId(String requestBody) {
        if (!requestBody.contains("RequestID")) {
            return null;
        }
        try {
            int position = requestBody.indexOf("RequestID=\"") + 11;
            int nextPosition = requestBody.indexOf("\"", position);
            return requestBody.substring(position, nextPosition);
        }
        catch (Exception e) {
            LOGGER.debug("Exception parsing RequestID from request.", (Throwable)e);
            return null;
        }
    }

    protected static String getRequestBody(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

