/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.saml.web.view;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.support.saml.util.Saml10ObjectBuilder;
import org.jasig.cas.support.saml.web.support.SamlArgumentExtractor;
import org.jasig.cas.web.view.AbstractCasView;
import org.joda.time.DateTime;
import org.opensaml.saml.saml1.core.Response;

public abstract class AbstractSaml10ResponseView
extends AbstractCasView {
    private static final String DEFAULT_ENCODING = "UTF-8";
    protected final Saml10ObjectBuilder samlObjectBuilder = new Saml10ObjectBuilder();
    private final SamlArgumentExtractor samlArgumentExtractor = new SamlArgumentExtractor();
    @NotNull
    private String encoding = "UTF-8";
    private int skewAllowance;

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSkewAllowance(int skewAllowance) {
        this.logger.debug("Using {} seconds as skew allowance.", (Object)skewAllowance);
        this.skewAllowance = skewAllowance;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setCharacterEncoding(this.encoding);
        WebApplicationService service = this.samlArgumentExtractor.extractService(request);
        String serviceId = service != null ? service.getId() : "UNKNOWN";
        try {
            Response samlResponse = this.samlObjectBuilder.newResponse(this.samlObjectBuilder.generateSecureRandomId(), DateTime.now().minusSeconds(this.skewAllowance), serviceId, service);
            this.prepareResponse(samlResponse, model);
            this.samlObjectBuilder.encodeSamlResponse(response, request, samlResponse);
        }
        catch (Exception e) {
            this.logger.error("Error generating SAML response for service {}.", (Object)serviceId);
            throw e;
        }
    }

    protected abstract void prepareResponse(Response var1, Map<String, Object> var2);
}

