/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.webflow.execution.repository.BadlyFormattedFlowExecutionKeyException;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;

public final class FlowExecutionExceptionResolver
implements HandlerExceptionResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private String modelKey = "exception.message";

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        if (!(exception instanceof FlowExecutionRepositoryException) || exception instanceof BadlyFormattedFlowExecutionKeyException) {
            this.logger.debug("Ignoring the received exception due to a type mismatch", (Throwable)exception);
            return null;
        }
        String urlToRedirectTo = request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
        this.logger.debug("Error getting flow information for URL [{}]", (Object)urlToRedirectTo, (Object)exception);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put(this.modelKey, StringEscapeUtils.escapeHtml((String)exception.getMessage()));
        return new ModelAndView((View)new RedirectView(urlToRedirectTo), model);
    }

    public void setModelKey(String modelKey) {
        this.modelKey = modelKey;
    }
}

