/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.view;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class CasReloadableMessageBundle
extends ReloadableResourceBundleMessageSource {
    private String[] basenames;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected String getDefaultMessage(String code) {
        String messageToReturn = super.getDefaultMessage(code);
        if (!StringUtils.isBlank((String)messageToReturn) && messageToReturn.equals(code)) {
            this.logger.warn("The code [{}] cannot be found in the default language bundle and will be used as the message itself.", (Object)code);
        }
        return messageToReturn;
    }

    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        boolean foundCode = false;
        if (!locale.equals(Locale.ENGLISH)) {
            for (int i = 0; !foundCode && i < this.basenames.length; ++i) {
                String filename = this.basenames[i] + "_" + locale;
                this.logger.debug("Examining language bundle [{}] for the code [{}]", (Object)filename, (Object)code);
                ReloadableResourceBundleMessageSource.PropertiesHolder holder = this.getProperties(filename);
                foundCode = holder != null && holder.getProperties() != null && holder.getProperty(code) != null;
            }
            if (!foundCode) {
                this.logger.warn("The code [{}] cannot be found in the language bundle for the locale [{}]", (Object)code, (Object)locale);
            }
        }
        return super.getMessageInternal(code, args, locale);
    }

    public void setBasenames(String ... basenames) {
        this.basenames = basenames;
        super.setBasenames(basenames);
    }
}

